/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.merging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.block.stargate.StargateOrlinMemberBlock;
import mrjake.aunis.stargate.EnumMemberVariant;
import mrjake.aunis.stargate.merging.StargateAbstractMergeHelper;
import mrjake.aunis.tileentity.stargate.StargateOrlinMemberTile;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.FacingToRotation;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StargateOrlinMergeHelper
extends StargateAbstractMergeHelper {
    public static final StargateOrlinMergeHelper INSTANCE = new StargateOrlinMergeHelper();
    private static final AunisAxisAlignedBB BASE_SEARCH_BOX = new AunisAxisAlignedBB(-1.0, -2.0, -1.0, 1.0, 0.0, 1.0);
    public static final BlockMatcher BASE_MATCHER = BlockMatcher.func_177642_a((Block)AunisBlocks.STARGATE_ORLIN_BASE_BLOCK);
    public static final BlockMatcher MEMBER_MATCHER = BlockMatcher.func_177642_a((Block)AunisBlocks.STARGATE_ORLIN_MEMBER_BLOCK);
    private static final Map<BlockPos, EnumFacing> BLOCK_MAP = new HashMap<BlockPos, EnumFacing>();

    @Override
    public List<BlockPos> getRingBlocks() {
        return new ArrayList<BlockPos>(BLOCK_MAP.keySet());
    }

    @Override
    public List<BlockPos> getChevronBlocks() {
        return new ArrayList<BlockPos>(0);
    }

    @Override
    @Nullable
    public EnumMemberVariant getMemberVariantFromItemStack(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        if (((ItemBlock)stack.func_77973_b()).func_179223_d() != AunisBlocks.STARGATE_ORLIN_MEMBER_BLOCK) {
            return null;
        }
        return EnumMemberVariant.RING;
    }

    @Override
    public AunisAxisAlignedBB getBaseSearchBox() {
        return BASE_SEARCH_BOX;
    }

    @Override
    public boolean matchBase(IBlockState state) {
        return BASE_MATCHER.apply(state);
    }

    @Override
    public boolean matchMember(IBlockState state) {
        return MEMBER_MATCHER.apply(state);
    }

    @Override
    public StargateOrlinMemberBlock getMemberBlock() {
        return AunisBlocks.STARGATE_ORLIN_MEMBER_BLOCK;
    }

    @Override
    protected boolean checkMemberBlock(IBlockAccess blockAccess, BlockPos pos, EnumFacing facing, EnumMemberVariant variant) {
        IBlockState state = blockAccess.func_180495_p(pos);
        return MEMBER_MATCHER.apply(state) && state.func_177229_b((IProperty)AunisProps.ORLIN_VARIANT) == facing && !((StargateOrlinMemberTile)blockAccess.func_175625_s(pos)).isBroken();
    }

    @Override
    protected void updateMemberMergeStatus(World world, BlockPos checkPos, BlockPos basePos, EnumFacing baseFacing, boolean shouldBeMerged) {
        EnumFacing variant = BLOCK_MAP.get(checkPos);
        IBlockState memberState = world.func_180495_p(checkPos = checkPos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos));
        if (MEMBER_MATCHER.apply(memberState)) {
            StargateOrlinMemberTile memberTile = (StargateOrlinMemberTile)world.func_175625_s(checkPos);
            if (baseFacing == EnumFacing.NORTH) {
                if (variant == EnumFacing.WEST) {
                    variant = EnumFacing.EAST;
                } else if (variant == EnumFacing.EAST) {
                    variant = EnumFacing.WEST;
                }
            }
            if (baseFacing == EnumFacing.WEST) {
                if (variant == EnumFacing.WEST) {
                    variant = EnumFacing.NORTH;
                } else if (variant == EnumFacing.EAST) {
                    variant = EnumFacing.SOUTH;
                }
            }
            if (baseFacing == EnumFacing.EAST) {
                if (variant == EnumFacing.WEST) {
                    variant = EnumFacing.SOUTH;
                } else if (variant == EnumFacing.EAST) {
                    variant = EnumFacing.NORTH;
                }
            }
            if (shouldBeMerged && !memberTile.isMerged() || memberTile.isMerged() && memberTile.getBasePos().equals((Object)basePos)) {
                memberState = memberState.func_177226_a((IProperty)AunisProps.ORLIN_VARIANT, (Comparable)(shouldBeMerged ? variant : baseFacing));
                world.func_175656_a(checkPos, memberState.func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(!shouldBeMerged)));
                memberTile.setBasePos((BlockPos)(shouldBeMerged ? basePos : null));
            }
        }
    }

    public void incrementMembersOpenCount(World world, BlockPos basePos, EnumFacing baseFacing) {
        for (BlockPos pos : this.getRingBlocks()) {
            if (!MEMBER_MATCHER.apply(world.func_180495_p(pos = pos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos)))) continue;
            StargateOrlinMemberTile memberTile = (StargateOrlinMemberTile)world.func_175625_s(pos);
            memberTile.incrementOpenCount();
        }
    }

    public int getMaxOpenCount(World world, BlockPos basePos, EnumFacing baseFacing) {
        int max = 0;
        for (BlockPos pos : this.getRingBlocks()) {
            StargateOrlinMemberTile memberTile;
            int open;
            if (!MEMBER_MATCHER.apply(world.func_180495_p(pos = pos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos))) || (open = (memberTile = (StargateOrlinMemberTile)world.func_175625_s(pos)).getOpenCount()) <= max) continue;
            max = open;
        }
        return max;
    }

    static {
        BLOCK_MAP.put(new BlockPos(-1, 0, 0), EnumFacing.EAST);
        BLOCK_MAP.put(new BlockPos(-1, 1, 0), EnumFacing.DOWN);
        BLOCK_MAP.put(new BlockPos(-1, 2, 0), EnumFacing.UP);
        BLOCK_MAP.put(new BlockPos(0, 2, 0), EnumFacing.UP);
        BLOCK_MAP.put(new BlockPos(1, 2, 0), EnumFacing.UP);
        BLOCK_MAP.put(new BlockPos(1, 1, 0), EnumFacing.DOWN);
        BLOCK_MAP.put(new BlockPos(1, 0, 0), EnumFacing.WEST);
    }
}

