/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.merging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.block.stargate.StargateMilkyWayMemberBlock;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.stargate.EnumMemberVariant;
import mrjake.aunis.stargate.merging.StargateClassicMergeHelper;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.FacingToRotation;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class StargateMilkyWayMergeHelper
extends StargateClassicMergeHelper {
    public static final StargateMilkyWayMergeHelper INSTANCE = new StargateMilkyWayMergeHelper();
    private static final AunisAxisAlignedBB BASE_SEARCH_BOX_SMALL = new AunisAxisAlignedBB(-3.0, -7.0, 0.0, 3.0, 0.0, 0.0);
    private static final AunisAxisAlignedBB BASE_SEARCH_BOX_LARGE = new AunisAxisAlignedBB(-5.0, -9.0, 0.0, 5.0, 0.0, 0.0);
    public static final BlockMatcher BASE_MATCHER = BlockMatcher.func_177642_a((Block)AunisBlocks.STARGATE_MILKY_WAY_BASE_BLOCK);
    public static final BlockMatcher MEMBER_MATCHER = BlockMatcher.func_177642_a((Block)AunisBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK);
    private static final List<BlockPos> RING_BLOCKS_SMALL = Arrays.asList(new BlockPos(1, 7, 0), new BlockPos(3, 5, 0), new BlockPos(3, 3, 0), new BlockPos(2, 1, 0), new BlockPos(-2, 1, 0), new BlockPos(-3, 3, 0), new BlockPos(-3, 5, 0), new BlockPos(-1, 7, 0));
    private static final List<BlockPos> CHEVRON_BLOCKS_SMALL = Arrays.asList(new BlockPos(2, 6, 0), new BlockPos(3, 4, 0), new BlockPos(3, 2, 0), new BlockPos(-3, 2, 0), new BlockPos(-3, 4, 0), new BlockPos(-2, 6, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 7, 0));
    private static final List<BlockPos> RING_BLOCKS_LARGE = Arrays.asList(new BlockPos(-1, 0, 0), new BlockPos(-3, 1, 0), new BlockPos(-4, 3, 0), new BlockPos(-5, 4, 0), new BlockPos(-4, 6, 0), new BlockPos(-4, 7, 0), new BlockPos(-2, 9, 0), new BlockPos(-1, 9, 0), new BlockPos(1, 9, 0), new BlockPos(2, 9, 0), new BlockPos(4, 7, 0), new BlockPos(4, 6, 0), new BlockPos(5, 4, 0), new BlockPos(4, 3, 0), new BlockPos(3, 1, 0), new BlockPos(1, 0, 0));
    private static final List<BlockPos> CHEVRON_BLOCKS_LARGE = Arrays.asList(new BlockPos(3, 8, 0), new BlockPos(5, 5, 0), new BlockPos(4, 2, 0), new BlockPos(-4, 2, 0), new BlockPos(-5, 5, 0), new BlockPos(-3, 8, 0), new BlockPos(2, 0, 0), new BlockPos(-2, 0, 0), new BlockPos(0, 9, 0));

    @Override
    public List<BlockPos> getRingBlocks() {
        switch (AunisConfig.stargateSize) {
            case SMALL: 
            case MEDIUM: {
                return RING_BLOCKS_SMALL;
            }
            case LARGE: {
                return RING_BLOCKS_LARGE;
            }
        }
        return null;
    }

    @Override
    public List<BlockPos> getChevronBlocks() {
        switch (AunisConfig.stargateSize) {
            case SMALL: 
            case MEDIUM: {
                return CHEVRON_BLOCKS_SMALL;
            }
            case LARGE: {
                return CHEVRON_BLOCKS_LARGE;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public EnumMemberVariant getMemberVariantFromItemStack(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        if (((ItemBlock)stack.func_77973_b()).func_179223_d() != AunisBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK) {
            return null;
        }
        int meta = stack.func_77960_j();
        if (meta == AunisBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK.RING_META) {
            return EnumMemberVariant.RING;
        }
        if (meta == AunisBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK.CHEVRON_META) {
            return EnumMemberVariant.CHEVRON;
        }
        return null;
    }

    @Override
    public AunisAxisAlignedBB getBaseSearchBox() {
        switch (AunisConfig.stargateSize) {
            case SMALL: 
            case MEDIUM: {
                return BASE_SEARCH_BOX_SMALL;
            }
            case LARGE: {
                return BASE_SEARCH_BOX_LARGE;
            }
        }
        return null;
    }

    @Override
    public boolean matchBase(IBlockState state) {
        return BASE_MATCHER.apply(state);
    }

    @Override
    public boolean matchMember(IBlockState state) {
        return MEMBER_MATCHER.apply(state);
    }

    @Override
    public StargateMilkyWayMemberBlock getMemberBlock() {
        return AunisBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK;
    }

    public void convertToPattern(World world, BlockPos basePos, EnumFacing baseFacing, StargateSizeEnum currentStargateSize, StargateSizeEnum targetStargateSize) {
        Aunis.logger.debug(basePos + ": Converting Stargate from " + (Object)((Object)currentStargateSize) + " to " + (Object)((Object)targetStargateSize));
        ArrayList<BlockPos> oldPatternBlocks = new ArrayList<BlockPos>();
        switch (currentStargateSize) {
            case SMALL: 
            case MEDIUM: {
                oldPatternBlocks.addAll(RING_BLOCKS_SMALL);
                oldPatternBlocks.addAll(CHEVRON_BLOCKS_SMALL);
                break;
            }
            case LARGE: {
                oldPatternBlocks.addAll(RING_BLOCKS_LARGE);
                oldPatternBlocks.addAll(CHEVRON_BLOCKS_LARGE);
            }
        }
        for (BlockPos pos : oldPatternBlocks) {
            world.func_175698_g(pos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos));
        }
        IBlockState memberState = AunisBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK.func_176223_P().func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)baseFacing).func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(false));
        for (BlockPos pos : this.getRingBlocks()) {
            world.func_175656_a(pos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos), memberState.func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.RING)));
        }
        for (BlockPos pos : this.getChevronBlocks()) {
            world.func_175656_a(pos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos), memberState.func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.CHEVRON)));
        }
    }
}

