/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.merging;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrjake.aunis.block.stargate.StargateAbstractMemberBlock;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.stargate.EnumMemberVariant;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.BlockHelpers;
import mrjake.aunis.util.FacingToRotation;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class StargateAbstractMergeHelper {
    private BlockPos topBlock = null;

    @Nonnull
    public abstract List<BlockPos> getRingBlocks();

    @Nonnull
    public abstract List<BlockPos> getChevronBlocks();

    public BlockPos getTopBlock() {
        if (this.topBlock == null) {
            this.topBlock = BlockHelpers.getHighest(this.getChevronBlocks());
        }
        if (this.topBlock == null) {
            this.topBlock = BlockHelpers.getHighest(this.getRingBlocks());
        }
        return this.topBlock;
    }

    @Nonnull
    public List<BlockPos> getAbsentBlockPositions(IBlockAccess world, BlockPos basePos, EnumFacing facing, EnumMemberVariant variant) {
        List<BlockPos> blocks = null;
        switch (variant) {
            case CHEVRON: {
                blocks = this.getChevronBlocks();
                break;
            }
            case RING: {
                blocks = this.getRingBlocks();
            }
        }
        return blocks.stream().map(pos -> pos.func_190942_a(FacingToRotation.get(facing)).func_177971_a((Vec3i)basePos)).filter(pos -> !this.matchMember(world.func_180495_p(pos))).collect(Collectors.toList());
    }

    @Nullable
    public abstract EnumMemberVariant getMemberVariantFromItemStack(ItemStack var1);

    public abstract AunisAxisAlignedBB getBaseSearchBox();

    public abstract boolean matchBase(IBlockState var1);

    public abstract boolean matchMember(IBlockState var1);

    public abstract StargateAbstractMemberBlock getMemberBlock();

    @Nullable
    public StargateAbstractBaseTile findBaseTile(IBlockAccess blockAccess, BlockPos memberPos, EnumFacing facing) {
        AunisAxisAlignedBB globalBox = this.getBaseSearchBox().rotate(facing).offset(memberPos);
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)globalBox.getMinBlockPos(), (BlockPos)globalBox.getMaxBlockPos())) {
            if (!this.matchBase(blockAccess.func_180495_p((BlockPos)pos))) continue;
            return (StargateAbstractBaseTile)blockAccess.func_175625_s(pos.func_185334_h());
        }
        return null;
    }

    protected abstract boolean checkMemberBlock(IBlockAccess var1, BlockPos var2, EnumFacing var3, EnumMemberVariant var4);

    public boolean checkBlocks(IBlockAccess blockAccess, BlockPos basePos, EnumFacing baseFacing) {
        if (AunisConfig.debugConfig.checkGateMerge) {
            for (BlockPos pos : this.getRingBlocks()) {
                if (this.checkMemberBlock(blockAccess, pos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos), baseFacing, EnumMemberVariant.RING)) continue;
                return false;
            }
            for (BlockPos pos : this.getChevronBlocks()) {
                if (this.checkMemberBlock(blockAccess, pos.func_190942_a(FacingToRotation.get(baseFacing)).func_177971_a((Vec3i)basePos), baseFacing, EnumMemberVariant.CHEVRON)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract void updateMemberMergeStatus(World var1, BlockPos var2, BlockPos var3, EnumFacing var4, boolean var5);

    public void updateMembersMergeStatus(World world, BlockPos basePos, EnumFacing baseFacing, boolean shouldBeMerged) {
        for (BlockPos pos : this.getRingBlocks()) {
            this.updateMemberMergeStatus(world, pos, basePos, baseFacing, shouldBeMerged);
        }
        for (BlockPos pos : this.getChevronBlocks()) {
            this.updateMemberMergeStatus(world, pos, basePos, baseFacing, shouldBeMerged);
        }
    }

    public void updateMembersBasePos(IBlockAccess blockAccess, BlockPos basePos, EnumFacing baseFacing) {
    }
}

