/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mrjake.aunis.Aunis;
import mrjake.aunis.stargate.EnumSpinDirection;
import mrjake.aunis.stargate.ISpinHelper;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.util.math.MathFunction;
import mrjake.aunis.util.math.MathFunctionLinear;
import mrjake.aunis.util.math.MathFunctionQuadratic;
import mrjake.aunis.util.math.MathRange;
import mrjake.aunis.util.math.MathRangedFunction;

public class StargatePegasusSpinHelper
implements ISpinHelper {
    public static float A_ANGLE_PER_TICK = 5.0f;
    public static final float U_SPEEDUP_TIME = 0.0f;
    public static final float S_STOP_TIME = 0.0f;
    public SymbolTypeEnum symbolType;
    public boolean isSpinning;
    public SymbolInterface currentSymbol;
    public EnumSpinDirection direction = EnumSpinDirection.CLOCKWISE;
    private long spinStartTime;
    private SymbolInterface targetSymbol;
    private float startOffset;
    private static final MathRangedFunction SPEEDUP_PHASE_DEFAULT = StargatePegasusSpinHelper.getSpeedupRangedFunction(A_ANGLE_PER_TICK, 0.0f);
    private static final MathFunctionLinear LINEAR_SPIN_FUNCTION_DEFAULT = StargatePegasusSpinHelper.getLinearSpinFunction(A_ANGLE_PER_TICK, 0.0f);
    private Map<MathRange, MathFunction> phases = new HashMap<MathRange, MathFunction>(3);

    public StargatePegasusSpinHelper() {
    }

    @Override
    public boolean getIsSpinning() {
        return this.isSpinning;
    }

    @Override
    public void setIsSpinning(boolean value) {
        this.isSpinning = value;
    }

    @Override
    public SymbolInterface getCurrentSymbol() {
        return this.currentSymbol;
    }

    @Override
    public void setCurrentSymbol(SymbolInterface symbol) {
        this.currentSymbol = symbol;
    }

    @Override
    public SymbolInterface getTargetSymbol() {
        return this.targetSymbol;
    }

    private static MathRangedFunction getSpeedupRangedFunction(float a, float u) {
        return new MathRangedFunction(new MathRange(0.0f, u), new MathFunctionQuadratic(a / (2.0f * u), 0.0f, 0.0f));
    }

    private static MathFunctionLinear getLinearSpinFunction(float a, float u) {
        return new MathFunctionLinear(a, -a * u / 2.0f);
    }

    private static MathFunctionQuadratic getStopFunction(float a, float u, float s, float x0) {
        return new MathFunctionQuadratic(-a / (2.0f * s), a + a * x0 / s, -(a * u / 2.0f + a * x0 * x0 / (2.0f * s)));
    }

    private static float getx0(float targetAngle) {
        return targetAngle / A_ANGLE_PER_TICK + 0.0f;
    }

    private static float getTargetRotation(float x0) {
        return A_ANGLE_PER_TICK * x0 + A_ANGLE_PER_TICK * 0.0f / 2.0f;
    }

    public static float getMinimalDistance() {
        return StargatePegasusSpinHelper.getTargetRotation(0.0f);
    }

    public static int getAnimationDuration(float distance) {
        return (int)(StargatePegasusSpinHelper.getx0(distance) + 0.0f);
    }

    public StargatePegasusSpinHelper(SymbolTypeEnum symbolType, SymbolInterface currentSymbol, EnumSpinDirection spinDirection, boolean isSpinning, SymbolInterface targetRingSymbol, long spinStartTime, int plusRounds) {
        this.symbolType = symbolType;
        this.currentSymbol = currentSymbol;
        this.direction = spinDirection;
        this.isSpinning = isSpinning;
        this.targetSymbol = targetRingSymbol;
        this.spinStartTime = spinStartTime;
    }

    @Override
    public void initRotation(long totalWorldTime, SymbolInterface targetSymbol, EnumSpinDirection direction, float startOffset, int plusRounds) {
        this.targetSymbol = targetSymbol;
        this.direction = direction;
        this.spinStartTime = totalWorldTime;
        this.startOffset = startOffset;
        this.isSpinning = true;
    }

    private float calculate(float tick) {
        if (tick < 0.0f) {
            Aunis.logger.warn("Negative argument");
            return 0.0f;
        }
        return tick % 36.0f;
    }

    @Override
    public float apply(double tick) {
        float slot = this.calculate((float)tick - (float)this.spinStartTime);
        return ((this.direction.mul == -1 ? 36.0f - slot : slot) + this.startOffset) % 36.0f;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.symbolType.id);
        buf.writeBoolean(this.isSpinning);
        buf.writeInt(this.currentSymbol.getId());
        buf.writeInt(this.direction.id);
        buf.writeLong(this.spinStartTime);
        buf.writeInt(this.targetSymbol.getId());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.symbolType = SymbolTypeEnum.valueOf(buf.readInt());
        this.isSpinning = buf.readBoolean();
        this.currentSymbol = this.symbolType.valueOfSymbol(buf.readInt());
        this.direction = EnumSpinDirection.valueOf(buf.readInt());
        this.spinStartTime = buf.readLong();
        this.targetSymbol = this.symbolType.valueOfSymbol(buf.readInt());
        if (this.isSpinning) {
            this.initRotation(this.spinStartTime, this.targetSymbol, this.direction, 0.0f, 0);
        }
    }
}

