/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mrjake.aunis.Aunis;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.stargate.EnumSpinDirection;
import mrjake.aunis.stargate.ISpinHelper;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.stargate.network.SymbolUniverseEnum;
import mrjake.aunis.util.math.MathFunction;
import mrjake.aunis.util.math.MathFunctionLinear;
import mrjake.aunis.util.math.MathFunctionQuadratic;
import mrjake.aunis.util.math.MathRange;
import mrjake.aunis.util.math.MathRangedFunction;

public class StargateClassicSpinHelper
implements ISpinHelper {
    public static float A_ANGLE_PER_TICK = AunisConfig.stargateConfig.classicGateSpinSpeed;
    public static final float U_SPEEDUP_TIME = 35.0f;
    public static final float S_STOP_TIME = 25.0f;
    public SymbolTypeEnum symbolType;
    public boolean isSpinning;
    public SymbolInterface currentSymbol;
    public EnumSpinDirection direction = EnumSpinDirection.CLOCKWISE;
    private long spinStartTime;
    private SymbolInterface targetSymbol;
    private float targetRotationOffset;
    public int plusRounds;
    private static final MathRangedFunction SPEEDUP_PHASE_DEFAULT = StargateClassicSpinHelper.getSpeedupRangedFunction(A_ANGLE_PER_TICK, 35.0f);
    private static final MathFunctionLinear LINEAR_SPIN_FUNCTION_DEFAULT = StargateClassicSpinHelper.getLinearSpinFunction(A_ANGLE_PER_TICK, 35.0f);
    private Map<MathRange, MathFunction> phases = new HashMap<MathRange, MathFunction>(3);

    public StargateClassicSpinHelper() {
    }

    @Override
    public boolean getIsSpinning() {
        return this.isSpinning;
    }

    @Override
    public void setIsSpinning(boolean value) {
        this.isSpinning = value;
    }

    @Override
    public SymbolInterface getCurrentSymbol() {
        return this.currentSymbol;
    }

    @Override
    public void setCurrentSymbol(SymbolInterface symbol) {
        this.currentSymbol = symbol;
    }

    @Override
    public SymbolInterface getTargetSymbol() {
        return this.targetSymbol;
    }

    private static MathRangedFunction getSpeedupRangedFunction(float a, float u) {
        return new MathRangedFunction(new MathRange(0.0f, u), new MathFunctionQuadratic(a / (2.0f * u), 0.0f, 0.0f));
    }

    private static MathFunctionLinear getLinearSpinFunction(float a, float u) {
        return new MathFunctionLinear(a, -a * u / 2.0f);
    }

    private static MathFunctionQuadratic getStopFunction(float a, float u, float s, float x0) {
        return new MathFunctionQuadratic(-a / (2.0f * s), a + a * x0 / s, -(a * u / 2.0f + a * x0 * x0 / (2.0f * s)));
    }

    private static float getx0(float targetAngle) {
        return targetAngle / A_ANGLE_PER_TICK + 5.0f;
    }

    private static float getTargetRotation(float x0) {
        return A_ANGLE_PER_TICK * x0 + A_ANGLE_PER_TICK * -10.0f / 2.0f;
    }

    public static float getMinimalDistance() {
        return StargateClassicSpinHelper.getTargetRotation(35.0f);
    }

    public static int getAnimationDuration(float distance) {
        return (int)(StargateClassicSpinHelper.getx0(distance) + 25.0f);
    }

    public static int getAnimationDistance(float duration) {
        return (int)(duration * 2.0f - 35.0f - 25.0f);
    }

    public StargateClassicSpinHelper(SymbolTypeEnum symbolType, SymbolInterface currentSymbol, EnumSpinDirection spinDirection, boolean isSpinning, SymbolInterface targetRingSymbol, long spinStartTime, int plusRounds) {
        this.symbolType = symbolType;
        this.currentSymbol = currentSymbol;
        this.direction = spinDirection;
        this.isSpinning = isSpinning;
        this.targetSymbol = targetRingSymbol;
        this.spinStartTime = spinStartTime;
        this.plusRounds = plusRounds;
    }

    @Override
    public void initRotation(long totalWorldTime, SymbolInterface targetSymbol, EnumSpinDirection direction, float startOffset, int plusRounds) {
        float distance = direction.getDistance(this.currentSymbol, targetSymbol);
        distance += (float)(360 * plusRounds);
        if (targetSymbol == SymbolUniverseEnum.G37) {
            distance = 360.0f;
            targetSymbol = SymbolUniverseEnum.TOP_CHEVRON;
        }
        float x0 = StargateClassicSpinHelper.getx0(distance);
        this.targetRotationOffset = StargateClassicSpinHelper.getTargetRotation(x0);
        this.phases.clear();
        if (x0 < 35.0f) {
            x0 = (x0 + 25.0f) / 2.0f;
            float a = distance / x0;
            MathRangedFunction speedup = StargateClassicSpinHelper.getSpeedupRangedFunction(a, x0);
            this.phases.put(speedup.range, speedup.function);
            this.phases.put(new MathRange(x0, x0 + x0), StargateClassicSpinHelper.getStopFunction(a, x0, x0, x0));
        } else {
            this.phases.put(StargateClassicSpinHelper.SPEEDUP_PHASE_DEFAULT.range, StargateClassicSpinHelper.SPEEDUP_PHASE_DEFAULT.function);
            this.phases.put(new MathRange(35.0f, x0), LINEAR_SPIN_FUNCTION_DEFAULT);
            this.phases.put(new MathRange(x0, x0 + 25.0f), StargateClassicSpinHelper.getStopFunction(A_ANGLE_PER_TICK, 35.0f, 25.0f, x0));
        }
        this.targetSymbol = targetSymbol;
        this.direction = direction;
        this.spinStartTime = totalWorldTime;
        this.isSpinning = true;
    }

    private float calculate(float tick) {
        if (tick < 0.0f) {
            Aunis.logger.warn("Negative argument");
            return 0.0f;
        }
        for (Map.Entry<MathRange, MathFunction> phase : this.phases.entrySet()) {
            if (!phase.getKey().test(Float.valueOf(tick))) continue;
            return phase.getValue().apply(tick);
        }
        this.isSpinning = false;
        this.currentSymbol = this.targetSymbol;
        return this.targetRotationOffset;
    }

    @Override
    public float apply(double tick) {
        return this.calculate((float)(tick - (double)this.spinStartTime)) * (float)this.direction.mul;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.symbolType.id);
        buf.writeBoolean(this.isSpinning);
        buf.writeInt(this.currentSymbol.getId());
        buf.writeInt(this.direction.id);
        buf.writeLong(this.spinStartTime);
        buf.writeInt(this.targetSymbol.getId());
        buf.writeInt(this.plusRounds);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.symbolType = SymbolTypeEnum.valueOf(buf.readInt());
        this.isSpinning = buf.readBoolean();
        this.currentSymbol = this.symbolType.valueOfSymbol(buf.readInt());
        this.direction = EnumSpinDirection.valueOf(buf.readInt());
        this.spinStartTime = buf.readLong();
        this.targetSymbol = this.symbolType.valueOfSymbol(buf.readInt());
        this.plusRounds = buf.readInt();
        if (this.isSpinning) {
            this.initRotation(this.spinStartTime, this.targetSymbol, this.direction, 0.0f, this.plusRounds);
        }
    }
}

