/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.sound;

import mrjake.aunis.Aunis;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.SoundPositionedPlayToClient;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.sound.SoundPositionedEnum;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class AunisSoundHelper {
    public static final SoundCategory AUNIS_SOUND_CATEGORY = Aunis.AUNIS_SOUNDS;

    public static void playPositionedSound(World world, BlockPos pos, SoundPositionedEnum soundEnum, boolean play) {
        AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new SoundPositionedPlayToClient(pos, soundEnum, play), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 512.0));
    }

    public static void playSoundEventClientSide(World world, BlockPos pos, SoundEventEnum soundEventEnum) {
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundEventEnum.soundEvent, AUNIS_SOUND_CATEGORY, soundEventEnum.volume * AunisConfig.avConfig.volume, 1.0f, false);
    }

    public static void playSoundEvent(World world, BlockPos pos, SoundEventEnum soundEventEnum) {
        world.func_184133_a(null, pos, soundEventEnum.soundEvent, AUNIS_SOUND_CATEGORY, soundEventEnum.volume * AunisConfig.avConfig.volume, 1.0f);
    }

    public static void playSoundToPlayer(EntityPlayerMP player, SoundEventEnum soundEventEnum, BlockPos pos) {
        player.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(soundEventEnum.soundEvent, AUNIS_SOUND_CATEGORY, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundEventEnum.volume * AunisConfig.avConfig.volume, 1.0f));
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEventEnum soundEventEnum : SoundEventEnum.values()) {
            event.getRegistry().register((IForgeRegistryEntry)soundEventEnum.soundEvent);
        }
    }
}

