/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.transportrings;

import java.util.ArrayList;
import java.util.List;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.transportrings.Ring;
import mrjake.aunis.state.transportrings.TransportRingsRendererState;
import mrjake.aunis.tesr.RendererInterface;
import mrjake.aunis.util.AunisAxisAlignedBB;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TransportRingsAbstractRenderer
implements RendererInterface {
    public static final int RING_COUNT = 5;
    public static final int INTERVAL_UPRISING = 5;
    public static final int INTERVAL_FALLING = 5;
    public static final double ANIMATION_SPEED_DIVISOR = 2.7;
    private World world;
    private AunisAxisAlignedBB localTeleportBox;
    private List<Ring> rings;
    private int currentRing;
    private int lastRingAnimated;
    private long lastTick;
    TransportRingsRendererState state = new TransportRingsRendererState();

    public TransportRingsAbstractRenderer(World world, BlockPos pos, AunisAxisAlignedBB localTeleportBox) {
        this.world = world;
        this.localTeleportBox = localTeleportBox;
        this.rings = new ArrayList<Ring>();
        for (int i = 0; i < 5; ++i) {
            this.rings.add(new Ring(world, i));
        }
    }

    @Override
    public void render(double x, double y, double z, float partialTicks) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (AunisConfig.debugConfig.renderBoundingBoxes) {
            this.localTeleportBox.render();
        }
        GlStateManager.func_179137_b((double)0.5, (double)1.666355, (double)0.5);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        for (Ring ring : this.rings) {
            ring.render(partialTicks, BiomeOverlayEnum.NORMAL);
        }
        GlStateManager.func_179121_F();
        long tick = this.world.func_82737_E() - this.state.animationStart;
        if (this.state.isAnimationActive) {
            if (this.state.ringsUprising) {
                if (tick > 30L && (tick -= 30L) % 5L == 0L && tick != this.lastTick) {
                    this.currentRing = (int)(tick / 5L) - 1;
                    for (int ring = this.lastRingAnimated + 1; ring < Math.min(this.currentRing, 5); ++ring) {
                        this.rings.get(ring).setTop();
                    }
                    if (this.currentRing < 5) {
                        this.rings.get(this.currentRing).animate(this.state.ringsUprising);
                        this.lastRingAnimated = this.currentRing;
                        this.lastTick = tick;
                    }
                    if (this.currentRing >= 4) {
                        this.state.ringsUprising = false;
                        this.lastRingAnimated = 5;
                        this.lastTick = -1L;
                    }
                }
            } else if (tick > 100L && (tick -= 100L) % 5L == 0L && tick != this.lastTick) {
                this.currentRing = 5 - (int)(tick / 5L);
                for (int ring = this.lastRingAnimated - 1; ring > Math.max(this.currentRing, -1); --ring) {
                    this.rings.get(ring).setDown();
                }
                if (this.currentRing >= 0) {
                    this.rings.get(this.currentRing).animate(this.state.ringsUprising);
                    this.lastRingAnimated = this.currentRing;
                    this.lastTick = tick;
                } else {
                    this.state.isAnimationActive = false;
                }
                this.lastTick = tick;
            }
        }
    }

    public void animationStart(long animationStart) {
        this.lastTick = -1L;
        this.currentRing = 0;
        this.lastRingAnimated = -1;
        this.state.animationStart = animationStart;
        this.state.ringsUprising = true;
        this.state.isAnimationActive = true;
    }

    public void setState(TransportRingsRendererState rendererState) {
        this.lastTick = -1L;
        this.state = rendererState;
    }
}

