/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.transportrings;

import mrjake.aunis.AunisProps;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.tesr.RendererInterface;
import mrjake.aunis.tileentity.transportrings.TRControllerAbstractTile;
import mrjake.vector.Vector3f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;

public abstract class TRControllerAbstractRenderer
implements RendererInterface {
    private TRControllerAbstractTile controllerTile;
    private EnumFacing facing;
    private static final Vector3f NORTH_TRANSLATION = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f EAST_TRANSLATION = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f SOUTH_TRANSLATION = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final Vector3f WEST_TRANSLATION = new Vector3f(0.0f, 0.0f, 1.0f);

    public TRControllerAbstractRenderer(TRControllerAbstractTile controllerTile) {
        this.controllerTile = controllerTile;
        IBlockState blockState = controllerTile.func_145831_w().func_180495_p(controllerTile.func_174877_v());
        this.facing = (EnumFacing)blockState.func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL);
    }

    public static Vector3f getTranslation(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return NORTH_TRANSLATION;
            }
            case EAST: {
                return EAST_TRANSLATION;
            }
            case SOUTH: {
                return SOUTH_TRANSLATION;
            }
            case WEST: {
                return WEST_TRANSLATION;
            }
        }
        return null;
    }

    public static int getRotation(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 270;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 90;
            }
        }
        return 0;
    }

    @Override
    public void render(double x, double y, double z, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Vector3f tr = TRControllerAbstractRenderer.getTranslation(this.facing);
        int rot = TRControllerAbstractRenderer.getRotation(this.facing);
        GlStateManager.func_179109_b((float)tr.x, (float)tr.y, (float)tr.z);
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        ElementEnum.RINGSCONTROLLER_GOAULD.bindTextureAndRender(this.controllerTile.getBiomeOverlay());
        ElementEnum.RINGSCONTROLLER_GOAULD_BUTTONS.bindTextureAndRender(this.controllerTile.getBiomeOverlay());
        GlStateManager.func_179121_F();
    }
}

