/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.transportrings;

import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class Ring {
    private World world;
    private boolean shouldRender;
    private boolean shouldAnimate;
    private boolean ringsUprising;
    private long animationStart;
    private double y;
    private double yMax;

    public Ring(World world, int index) {
        this.world = world;
        this.shouldRender = false;
        this.y = 0.0;
        this.yMax = (double)(4 - index) + 1.5;
    }

    public void render(double partialTicks, BiomeOverlayEnum biomeOverlay) {
        if (this.shouldRender) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)this.y, (double)0.0);
            ElementEnum.RINGS_BLACK.bindTextureAndRender(biomeOverlay);
            GlStateManager.func_179121_F();
        }
        if (this.shouldAnimate) {
            double effTick = (double)(this.world.func_82737_E() - this.animationStart) + partialTicks;
            if ((effTick /= 2.7) > Math.PI) {
                effTick = Math.PI;
                this.shouldAnimate = false;
            }
            float cos = MathHelper.func_76134_b((float)((float)effTick));
            if (this.ringsUprising) {
                cos *= -1.0f;
            }
            this.y = (double)((cos + 1.0f) / 2.0f) * this.yMax;
            if (!this.ringsUprising && effTick == Math.PI) {
                this.shouldRender = false;
            }
        }
    }

    public void animate(boolean ringsUprising) {
        this.ringsUprising = ringsUprising;
        this.shouldRender = true;
        this.animationStart = this.world.func_82737_E();
        this.shouldAnimate = true;
    }

    public void setTop() {
        this.y = this.yMax;
        this.shouldAnimate = false;
        this.shouldRender = true;
    }

    public void setDown() {
        this.shouldAnimate = false;
        this.shouldRender = false;
    }
}

