/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.stargate;

import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.loader.model.ModelLoader;
import mrjake.aunis.loader.texture.TextureLoader;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.renderer.stargate.StargateAbstractRendererState;
import mrjake.aunis.renderer.stargate.StargateClassicRenderer;
import mrjake.aunis.renderer.stargate.StargateUniverseRendererState;
import mrjake.aunis.stargate.EnumIrisType;
import mrjake.aunis.stargate.network.SymbolUniverseEnum;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class StargateUniverseRenderer
extends StargateClassicRenderer<StargateUniverseRendererState> {
    private static final float GATE_DIAMETER = 8.67415f;
    private static final float darkness = 0.6f;

    @Override
    protected void applyTransformations(StargateUniverseRendererState rendererState) {
        float scale = 0.9f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179137_b((double)0.5, (double)4.537075233459473, (double)0.55);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    @Override
    protected void renderGate(StargateUniverseRendererState rendererState, double partialTicks) {
        GlStateManager.func_179114_b((float)(-rendererState.horizontalRotation), (float)0.0f, (float)1.0f, (float)0.0f);
        float angularRotation = rendererState.spinHelper.getCurrentSymbol().getAngle();
        if (rendererState.spinHelper.getIsSpinning()) {
            angularRotation += rendererState.spinHelper.apply((double)this.func_178459_a().func_82737_E() + partialTicks);
        }
        GlStateManager.func_179114_b((float)(rendererState.horizontalRotation - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(angularRotation + 0.6f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderChevrons(rendererState, partialTicks);
        ElementEnum.UNIVERSE_GATE.bindTextureAndRender(rendererState.getBiomeOverlay());
        GlStateManager.func_179140_f();
        ElementEnum.UNIVERSE_CHEVRON.bindTexture(rendererState.getBiomeOverlay());
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            if (symbol.modelResource == null) continue;
            float color = rendererState.getSymbolColor(symbol) + 0.25f;
            GlStateManager.func_179124_c((float)color, (float)color, (float)color);
            ModelLoader.getModel(symbol.modelResource).render();
        }
        GlStateManager.func_179145_e();
        rendererState.iterate(this.func_178459_a(), partialTicks);
    }

    @Override
    protected ResourceLocation getEventHorizonTextureResource(StargateAbstractRendererState rendererState, boolean kawoosh) {
        if (AunisConfig.stargateConfig.disableAnimatedEventHorizon) {
            return kawoosh ? EV_HORIZON_DESATURATED_KAWOOSH_TEXTURE : EV_HORIZON_DESATURATED_TEXTURE;
        }
        return kawoosh ? EV_HORIZON_DESATURATED_KAWOOSH_TEXTURE_ANIMATED : EV_HORIZON_DESATURATED_TEXTURE_ANIMATED;
    }

    @Override
    protected void renderKawoosh(StargateAbstractRendererState rendererState, double partialTicks) {
        GlStateManager.func_179137_b((double)0.0, (double)0.04, (double)0.0);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
        super.renderKawoosh(rendererState, partialTicks);
    }

    @Override
    public void renderIris(double partialTicks, World world, StargateUniverseRendererState rendererState, boolean backOnly) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.04, (double)0.0);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
        if (rendererState.irisType == EnumIrisType.SHIELD) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179124_c((float)0.6f, (float)0.6f, (float)0.6f);
        }
        super.renderIris(partialTicks, world, rendererState, backOnly);
        GlStateManager.func_179121_F();
    }

    @Override
    protected void renderChevron(StargateUniverseRendererState rendererState, double partialTicks, ChevronEnum chevron) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(-chevron.rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        TextureLoader.getTexture(rendererState.chevronTextureList.get(rendererState.getBiomeOverlay(), chevron)).bindTexture();
        ElementEnum.UNIVERSE_CHEVRON.render();
        GlStateManager.func_179121_F();
    }
}

