/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.stargate;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.renderer.stargate.StargateClassicRendererState;
import mrjake.aunis.stargate.StargatePegasusSpinHelper;

public class StargatePegasusRendererState
extends StargateClassicRendererState {
    public Map<Integer, Integer> slotToGlyphMap = new HashMap<Integer, Integer>();
    public StargateSizeEnum stargateSize = AunisConfig.stargateSize;
    public boolean chevronOpen;
    public long chevronActionStart;
    public boolean chevronOpening;
    public boolean chevronClosing;

    public StargatePegasusRendererState() {
    }

    private StargatePegasusRendererState(StargatePegasusRendererStateBuilder builder) {
        super(builder);
        this.stargateSize = builder.stargateSize;
        this.spinHelper = new StargatePegasusSpinHelper(builder.symbolType, builder.currentRingSymbol, builder.spinDirection, builder.isSpinning, builder.targetRingSymbol, builder.spinStartTime, 0);
    }

    public int slotFromChevron(ChevronEnum chevron) {
        return (new int[]{9, 5, 1, 33, 29, 25, 21, 17, 13})[chevron.rotationIndex];
    }

    public void setGlyphAtSlot(int glyphId, int slot) {
        if (slot > 36) {
            return;
        }
        this.slotToGlyphMap.put(slot, glyphId);
    }

    public void lockChevron(int glyphId, ChevronEnum chevron) {
        this.setGlyphAtSlot(glyphId, this.slotFromChevron(chevron));
    }

    @Override
    public void clearChevrons(long time) {
        super.clearChevrons(time);
        this.clearGlyphs();
    }

    public void clearGlyphs() {
        this.slotToGlyphMap.clear();
    }

    public void openChevron(long totalWorldTime) {
        this.chevronActionStart = totalWorldTime;
        this.chevronOpening = true;
    }

    public void closeChevron(long totalWorldTime) {
        this.chevronActionStart = totalWorldTime;
        this.chevronClosing = true;
    }

    @Override
    protected String getChevronTextureBase() {
        return "pegasus/chevron";
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stargateSize.id);
        super.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.stargateSize = StargateSizeEnum.fromId(buf.readInt());
        super.fromBytes(buf, StargatePegasusSpinHelper.class);
    }

    public static StargatePegasusRendererStateBuilder builder() {
        return new StargatePegasusRendererStateBuilder();
    }

    public static class StargatePegasusRendererStateBuilder
    extends StargateClassicRendererState.StargateClassicRendererStateBuilder {
        private StargateSizeEnum stargateSize;

        public StargatePegasusRendererStateBuilder() {
        }

        public StargatePegasusRendererStateBuilder(StargateClassicRendererState.StargateClassicRendererStateBuilder superBuilder) {
            super(superBuilder);
            this.setSymbolType(superBuilder.symbolType);
            this.setActiveChevrons(superBuilder.activeChevrons);
            this.setFinalActive(superBuilder.isFinalActive);
            this.setCurrentRingSymbol(superBuilder.currentRingSymbol);
            this.setSpinDirection(superBuilder.spinDirection);
            this.setSpinning(superBuilder.isSpinning);
            this.setTargetRingSymbol(superBuilder.targetRingSymbol);
            this.setSpinStartTime(superBuilder.spinStartTime);
            this.setBiomeOverride(superBuilder.biomeOverride);
            this.setIrisState(superBuilder.irisState);
            this.setIrisType(superBuilder.irisType);
            this.setIrisAnimation(superBuilder.irisAnimation);
            this.setPlusRounds(0);
        }

        public StargatePegasusRendererStateBuilder setStargateSize(StargateSizeEnum stargateSize) {
            this.stargateSize = stargateSize;
            return this;
        }

        @Override
        public StargatePegasusRendererState build() {
            return new StargatePegasusRendererState(this);
        }
    }
}

