/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.stargate;

import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.loader.texture.Texture;
import mrjake.aunis.loader.texture.TextureLoader;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.renderer.stargate.StargateClassicRenderer;
import mrjake.aunis.renderer.stargate.StargatePegasusRendererState;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.util.math.NumberUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;

public class StargatePegasusRenderer
extends StargateClassicRenderer<StargatePegasusRendererState> {
    private static final Vec3d RING_LOC = new Vec3d(0.0, -0.122333, -5.97E-4);
    private static final float GATE_DIAMETER = 10.1815f;
    private static final int GLYPHS_COUNT = 36;

    @Override
    protected void applyTransformations(StargatePegasusRendererState rendererState) {
        GlStateManager.func_179137_b((double)0.5, (double)((double)5.09075f + rendererState.stargateSize.renderTranslationY), (double)0.5);
        GlStateManager.func_179139_a((double)rendererState.stargateSize.renderScale, (double)rendererState.stargateSize.renderScale, (double)rendererState.stargateSize.renderScale);
    }

    @Override
    protected void renderGate(StargatePegasusRendererState rendererState, double partialTicks) {
        int index;
        this.renderRing(rendererState, partialTicks);
        this.renderChevrons(rendererState, partialTicks);
        if (rendererState.spinHelper.getIsSpinning() && !rendererState.slotToGlyphMap.containsKey(index = (int)rendererState.spinHelper.apply((double)this.func_178459_a().func_82737_E() + partialTicks))) {
            this.renderGlyph(rendererState.spinHelper.getTargetSymbol().getId(), index, false);
        }
        for (int i = 0; i < 38; ++i) {
            if (!rendererState.slotToGlyphMap.containsKey(i) && i < 36) {
                if (rendererState.spinHelper.getIsSpinning() || rendererState.slotToGlyphMap.size() != 0) continue;
                this.renderGlyph(i, i, true);
                continue;
            }
            if (!rendererState.slotToGlyphMap.containsKey(i) && i >= 36) continue;
            this.renderGlyph(rendererState.slotToGlyphMap.get(i), i, false);
        }
        ElementEnum.PEGASUS_GATE.bindTextureAndRender(rendererState.getBiomeOverlay());
    }

    private void renderRing(StargatePegasusRendererState rendererState, double partialTicks) {
        GlStateManager.func_179094_E();
        if (rendererState.horizontalRotation == 90.0f || rendererState.horizontalRotation == 270.0f) {
            GlStateManager.func_179137_b((double)StargatePegasusRenderer.RING_LOC.field_72448_b, (double)StargatePegasusRenderer.RING_LOC.field_72449_c, (double)StargatePegasusRenderer.RING_LOC.field_72450_a);
            GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-StargatePegasusRenderer.RING_LOC.field_72448_b), (double)(-StargatePegasusRenderer.RING_LOC.field_72449_c), (double)(-StargatePegasusRenderer.RING_LOC.field_72450_a));
        } else {
            GlStateManager.func_179137_b((double)StargatePegasusRenderer.RING_LOC.field_72450_a, (double)StargatePegasusRenderer.RING_LOC.field_72449_c, (double)StargatePegasusRenderer.RING_LOC.field_72448_b);
            GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-StargatePegasusRenderer.RING_LOC.field_72450_a), (double)(-StargatePegasusRenderer.RING_LOC.field_72449_c), (double)(-StargatePegasusRenderer.RING_LOC.field_72448_b));
        }
        ElementEnum.PEGASUS_RING.bindTextureAndRender(rendererState.getBiomeOverlay());
        GlStateManager.func_179121_F();
    }

    @Override
    protected void renderChevron(StargatePegasusRendererState rendererState, double partialTicks, ChevronEnum chevron) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)chevron.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        Texture chevronTexture = TextureLoader.getTexture(rendererState.chevronTextureList.get(rendererState.getBiomeOverlay(), chevron));
        if (chevronTexture != null) {
            chevronTexture.bindTexture();
            if (chevron.isFinal()) {
                float chevronOffset = 0.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)chevronOffset, (float)0.0f);
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render();
                GlStateManager.func_179109_b((float)0.0f, (float)(-2.0f * chevronOffset), (float)0.0f);
                ElementEnum.PEGASUS_CHEVRON_MOVING.render();
                GlStateManager.func_179121_F();
            } else {
                ElementEnum.PEGASUS_CHEVRON_MOVING.render();
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render();
            }
            ElementEnum.PEGASUS_CHEVRON_FRAME.bindTextureAndRender(rendererState.getBiomeOverlay());
            ElementEnum.PEGASUS_CHEVRON_BACK.render();
            GlStateManager.func_179121_F();
        }
    }

    private double[] getPositionInRingAtIndex(double radius, int index) {
        double deg = 10.0 * (double)index;
        double rad = Math.toRadians(deg);
        return new double[]{radius * Math.cos(rad), radius * Math.sin(rad), deg};
    }

    protected void renderGlyph(int glyphId, int slot, boolean deactivated) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, slot);
        GlStateManager.func_179137_b((double)NumberUtils.round(slotPos[0], 3), (double)NumberUtils.round(slotPos[1], 3), (double)0.205);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        String path = String.format("pegasus/%s.png", deactivated ? "glyphs_off" : "glyphs");
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLoader.getTextureResource(path));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double radius = 0.94;
        int textureSlot = SymbolPegasusEnum.valueOf((int)glyphId).textureSlot;
        double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
        double x = (uv[0] + radius) / 2.0;
        double y = (uv[1] + radius) / 2.0;
        double tileSize = 0.27;
        double uvSize = 0.0625;
        GlStateManager.func_179114_b((float)(10.0f * (float)(slot - textureSlot)), (float)0.0f, (float)1.0f, (float)0.0f);
        buffer.func_181662_b(-tileSize, 0.0, -tileSize).func_187315_a(x, y).func_181675_d();
        buffer.func_181662_b(-tileSize, 0.0, tileSize).func_187315_a(x, y + uvSize).func_181675_d();
        buffer.func_181662_b(tileSize, 0.0, tileSize).func_187315_a(x + uvSize, y + uvSize).func_181675_d();
        buffer.func_181662_b(tileSize, 0.0, -tileSize).func_187315_a(x + uvSize, y).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

