/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.stargate;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.renderer.stargate.StargateClassicRendererState;

public class StargateMilkyWayRendererState
extends StargateClassicRendererState {
    public StargateSizeEnum stargateSize = AunisConfig.stargateSize;
    public boolean chevronOpen;
    public long chevronActionStart;
    public boolean chevronOpening;
    public boolean chevronClosing;

    public StargateMilkyWayRendererState() {
    }

    private StargateMilkyWayRendererState(StargateMilkyWayRendererStateBuilder builder) {
        super(builder);
        this.stargateSize = builder.stargateSize;
    }

    public void openChevron(long totalWorldTime) {
        this.chevronActionStart = totalWorldTime;
        this.chevronOpening = true;
    }

    public void closeChevron(long totalWorldTime) {
        this.chevronActionStart = totalWorldTime;
        this.chevronClosing = true;
    }

    @Override
    protected String getChevronTextureBase() {
        return "milkyway/chevron";
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stargateSize.id);
        super.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.stargateSize = StargateSizeEnum.fromId(buf.readInt());
        super.fromBytes(buf);
    }

    public static StargateMilkyWayRendererStateBuilder builder() {
        return new StargateMilkyWayRendererStateBuilder();
    }

    public static class StargateMilkyWayRendererStateBuilder
    extends StargateClassicRendererState.StargateClassicRendererStateBuilder {
        private StargateSizeEnum stargateSize;

        public StargateMilkyWayRendererStateBuilder() {
        }

        public StargateMilkyWayRendererStateBuilder(StargateClassicRendererState.StargateClassicRendererStateBuilder superBuilder) {
            super(superBuilder);
            this.setSymbolType(superBuilder.symbolType);
            this.setActiveChevrons(superBuilder.activeChevrons);
            this.setFinalActive(superBuilder.isFinalActive);
            this.setCurrentRingSymbol(superBuilder.currentRingSymbol);
            this.setSpinDirection(superBuilder.spinDirection);
            this.setSpinning(superBuilder.isSpinning);
            this.setTargetRingSymbol(superBuilder.targetRingSymbol);
            this.setSpinStartTime(superBuilder.spinStartTime);
            this.setBiomeOverride(superBuilder.biomeOverride);
            this.setIrisState(superBuilder.irisState);
            this.setIrisType(superBuilder.irisType);
            this.setIrisCode(superBuilder.irisCode);
            this.setIrisMode(superBuilder.irisMode);
            this.setIrisAnimation(superBuilder.irisAnimation);
            this.setPlusRounds(superBuilder.plusRounds);
        }

        public StargateMilkyWayRendererStateBuilder setStargateSize(StargateSizeEnum stargateSize) {
            this.stargateSize = stargateSize;
            return this;
        }

        @Override
        public StargateMilkyWayRendererState build() {
            return new StargateMilkyWayRendererState(this);
        }
    }
}

