/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.stargate;

import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.loader.texture.TextureLoader;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.renderer.stargate.StargateClassicRenderer;
import mrjake.aunis.renderer.stargate.StargateMilkyWayRendererState;
import mrjake.aunis.util.math.MathFunction;
import mrjake.aunis.util.math.MathFunctionImpl;
import mrjake.aunis.util.math.MathRange;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class StargateMilkyWayRenderer
extends StargateClassicRenderer<StargateMilkyWayRendererState> {
    private static final Vec3d RING_LOC = new Vec3d(0.0, -0.122333, -5.97E-4);
    private static final float GATE_DIAMETER = 10.1815f;
    private static MathRange chevronOpenRange = new MathRange(0.0f, 1.57f);
    private static MathFunction chevronOpenFunction = new MathFunctionImpl(x -> x * x * x * x / 80.0f);
    private static MathRange chevronCloseRange = new MathRange(0.0f, 1.428f);
    private static MathFunction chevronCloseFunction = new MathFunctionImpl(x0 -> MathHelper.func_76134_b((float)(x0 * 1.1f)) / 12.0f);

    @Override
    protected void applyTransformations(StargateMilkyWayRendererState rendererState) {
        GlStateManager.func_179137_b((double)0.5, (double)((double)5.09075f + rendererState.stargateSize.renderTranslationY), (double)0.5);
        GlStateManager.func_179139_a((double)rendererState.stargateSize.renderScale, (double)rendererState.stargateSize.renderScale, (double)rendererState.stargateSize.renderScale);
    }

    @Override
    protected void renderGate(StargateMilkyWayRendererState rendererState, double partialTicks) {
        this.renderRing(rendererState, partialTicks);
        this.renderChevrons(rendererState, partialTicks);
        ElementEnum.MILKYWAY_GATE.bindTextureAndRender(rendererState.getBiomeOverlay());
    }

    private void renderRing(StargateMilkyWayRendererState rendererState, double partialTicks) {
        GlStateManager.func_179094_E();
        float angularRotation = rendererState.spinHelper.getCurrentSymbol().getAngle();
        if (rendererState.spinHelper.getIsSpinning()) {
            angularRotation += rendererState.spinHelper.apply((double)this.func_178459_a().func_82737_E() + partialTicks);
        }
        GlStateManager.func_179137_b((double)StargateMilkyWayRenderer.RING_LOC.field_72450_a, (double)StargateMilkyWayRenderer.RING_LOC.field_72449_c, (double)StargateMilkyWayRenderer.RING_LOC.field_72448_b);
        GlStateManager.func_179114_b((float)(-angularRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-StargateMilkyWayRenderer.RING_LOC.field_72450_a), (double)(-StargateMilkyWayRenderer.RING_LOC.field_72449_c), (double)(-StargateMilkyWayRenderer.RING_LOC.field_72448_b));
        ElementEnum.MILKYWAY_RING.bindTextureAndRender(rendererState.getBiomeOverlay());
        GlStateManager.func_179121_F();
    }

    private float calculateTopChevronOffset(StargateMilkyWayRendererState rendererState, double partialTicks) {
        float tick = (float)((double)(this.func_178459_a().func_82737_E() - rendererState.chevronActionStart) + partialTicks);
        float x = tick / 6.0f;
        if (rendererState.chevronOpening) {
            if (chevronOpenRange.test(Float.valueOf(x))) {
                return chevronOpenFunction.apply(x);
            }
            rendererState.chevronOpen = true;
            rendererState.chevronOpening = false;
        } else if (rendererState.chevronClosing) {
            if (chevronCloseRange.test(Float.valueOf(x))) {
                return chevronCloseFunction.apply(x);
            }
            rendererState.chevronOpen = false;
            rendererState.chevronClosing = false;
        }
        return rendererState.chevronOpen ? 0.08333f : 0.0f;
    }

    @Override
    protected void renderChevron(StargateMilkyWayRendererState rendererState, double partialTicks, ChevronEnum chevron) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)chevron.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        TextureLoader.getTexture(rendererState.chevronTextureList.get(rendererState.getBiomeOverlay(), chevron)).bindTexture();
        if (chevron.isFinal()) {
            float chevronOffset = this.calculateTopChevronOffset(rendererState, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)chevronOffset, (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_LIGHT.render();
            GlStateManager.func_179109_b((float)0.0f, (float)(-2.0f * chevronOffset), (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_MOVING.render();
            GlStateManager.func_179121_F();
        } else {
            ElementEnum.MILKYWAY_CHEVRON_MOVING.render();
            ElementEnum.MILKYWAY_CHEVRON_LIGHT.render();
        }
        ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTextureAndRender(rendererState.getBiomeOverlay());
        ElementEnum.MILKYWAY_CHEVRON_BACK.render();
        GlStateManager.func_179121_F();
    }
}

