/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.stargate;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.ChevronTextureList;
import mrjake.aunis.renderer.stargate.StargateAbstractRendererState;
import mrjake.aunis.stargate.EnumIrisMode;
import mrjake.aunis.stargate.EnumIrisState;
import mrjake.aunis.stargate.EnumIrisType;
import mrjake.aunis.stargate.EnumSpinDirection;
import mrjake.aunis.stargate.ISpinHelper;
import mrjake.aunis.stargate.StargateClassicSpinHelper;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class StargateClassicRendererState
extends StargateAbstractRendererState {
    public ChevronTextureList chevronTextureList;
    public ISpinHelper spinHelper;
    public BiomeOverlayEnum biomeOverride;
    public EnumIrisType irisType;
    public EnumIrisState irisState;
    public long irisAnimation;

    public StargateClassicRendererState() {
    }

    public StargateClassicRendererState(StargateClassicRendererStateBuilder builder) {
        super(builder);
        this.chevronTextureList = new ChevronTextureList(this.getChevronTextureBase(), builder.activeChevrons, builder.isFinalActive);
        this.spinHelper = new StargateClassicSpinHelper(builder.symbolType, builder.currentRingSymbol, builder.spinDirection, builder.isSpinning, builder.targetRingSymbol, builder.spinStartTime, builder.plusRounds);
        this.biomeOverride = builder.biomeOverride;
        this.irisState = builder.irisState;
        this.irisType = builder.irisType;
        this.irisAnimation = builder.irisAnimation;
    }

    public void startIrisAnimation(long animationStart) {
        this.irisAnimation = animationStart;
    }

    @Override
    public StargateAbstractRendererState initClient(BlockPos pos, EnumFacing facing, BiomeOverlayEnum biomeOverlay) {
        this.chevronTextureList.initClient();
        return super.initClient(pos, facing, biomeOverlay);
    }

    protected abstract String getChevronTextureBase();

    @Override
    public BiomeOverlayEnum getBiomeOverlay() {
        if (this.biomeOverride != null) {
            return this.biomeOverride;
        }
        return super.getBiomeOverlay();
    }

    public void clearChevrons(long time) {
        this.chevronTextureList.clearChevrons(time);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        this.chevronTextureList.toBytes(buf);
        this.spinHelper.toBytes(buf);
        if (this.biomeOverride != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.biomeOverride.ordinal());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeByte((int)this.irisState.id);
        buf.writeByte((int)this.irisType.id);
        buf.writeLong(this.irisAnimation);
        super.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.fromBytes(buf, StargateClassicSpinHelper.class);
    }

    protected void fromBytes(ByteBuf buf, Class<? extends ISpinHelper> type) {
        this.chevronTextureList = new ChevronTextureList(this.getChevronTextureBase());
        this.chevronTextureList.fromBytes(buf);
        try {
            this.spinHelper = type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        this.spinHelper.fromBytes(buf);
        if (buf.readBoolean()) {
            this.biomeOverride = BiomeOverlayEnum.values()[buf.readInt()];
        }
        this.irisState = EnumIrisState.getValue(buf.readByte());
        this.irisType = EnumIrisType.byId(buf.readByte());
        this.irisAnimation = buf.readLong();
        super.fromBytes(buf);
    }

    public static StargateClassicRendererStateBuilder builder() {
        return new StargateClassicRendererStateBuilder();
    }

    public static class StargateClassicRendererStateBuilder
    extends StargateAbstractRendererState.StargateAbstractRendererStateBuilder {
        protected SymbolTypeEnum symbolType;
        protected int activeChevrons;
        protected boolean isFinalActive;
        protected SymbolInterface currentRingSymbol;
        protected EnumSpinDirection spinDirection;
        protected boolean isSpinning;
        protected SymbolInterface targetRingSymbol;
        protected long spinStartTime;
        protected int plusRounds;
        public BiomeOverlayEnum biomeOverride;
        public EnumIrisState irisState;
        public EnumIrisType irisType;
        public int irisCode;
        public EnumIrisMode irisMode;
        public long irisAnimation;

        public StargateClassicRendererStateBuilder() {
        }

        public StargateClassicRendererStateBuilder(StargateAbstractRendererState.StargateAbstractRendererStateBuilder superBuilder) {
            this.setStargateState(superBuilder.stargateState);
        }

        public StargateClassicRendererStateBuilder setSymbolType(SymbolTypeEnum symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        public StargateClassicRendererStateBuilder setActiveChevrons(int activeChevrons) {
            this.activeChevrons = activeChevrons;
            return this;
        }

        public StargateClassicRendererStateBuilder setFinalActive(boolean isFinalActive) {
            this.isFinalActive = isFinalActive;
            return this;
        }

        public StargateClassicRendererStateBuilder setCurrentRingSymbol(SymbolInterface currentRingSymbol) {
            this.currentRingSymbol = currentRingSymbol;
            return this;
        }

        public StargateClassicRendererStateBuilder setSpinDirection(EnumSpinDirection spinDirection) {
            this.spinDirection = spinDirection;
            return this;
        }

        public StargateClassicRendererStateBuilder setSpinning(boolean isSpinning) {
            this.isSpinning = isSpinning;
            return this;
        }

        public StargateClassicRendererStateBuilder setTargetRingSymbol(SymbolInterface targetRingSymbol) {
            this.targetRingSymbol = targetRingSymbol;
            return this;
        }

        public StargateClassicRendererStateBuilder setSpinStartTime(long spinStartTime) {
            this.spinStartTime = spinStartTime;
            return this;
        }

        public StargateClassicRendererStateBuilder setBiomeOverride(BiomeOverlayEnum biomeOverride) {
            this.biomeOverride = biomeOverride;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisState(EnumIrisState irisState) {
            this.irisState = irisState;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisType(EnumIrisType irisType) {
            this.irisType = irisType;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisCode(int code) {
            this.irisCode = code;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisMode(EnumIrisMode mode) {
            this.irisMode = mode;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisAnimation(long irisAnimation) {
            this.irisAnimation = irisAnimation;
            return this;
        }

        public StargateClassicRendererStateBuilder setPlusRounds(int rounds) {
            this.plusRounds = rounds;
            return this;
        }
    }
}

