/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.stargate;

import java.util.HashMap;
import java.util.Map;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.loader.texture.Texture;
import mrjake.aunis.loader.texture.TextureLoader;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.renderer.stargate.StargateAbstractRenderer;
import mrjake.aunis.renderer.stargate.StargateClassicRendererState;
import mrjake.aunis.renderer.stargate.StargateRendererStatic;
import mrjake.aunis.stargate.EnumIrisState;
import mrjake.aunis.stargate.EnumIrisType;
import mrjake.aunis.stargate.EnumMemberVariant;
import mrjake.aunis.stargate.merging.StargateAbstractMergeHelper;
import mrjake.aunis.stargate.merging.StargateMilkyWayMergeHelper;
import mrjake.aunis.util.FacingToRotation;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public abstract class StargateClassicRenderer<S extends StargateClassicRendererState>
extends StargateAbstractRenderer<S> {
    protected static final ResourceLocation SHIELD_TEXTURE = new ResourceLocation("aunis", "textures/tesr/iris/shield.jpg");
    protected static final ResourceLocation IRIS_TEXTURE = new ResourceLocation("aunis", "textures/tesr/iris/iris_blade.jpg");
    public static final int PHYSICAL_IRIS_ANIMATION_LENGTH = 60;
    public static final int SHIELD_IRIS_ANIMATION_LENGTH = 10;

    @Override
    protected void applyLightMap(StargateClassicRendererState rendererState, double partialTicks) {
        int chevronCount = 6;
        int skyLight = 0;
        int blockLight = 0;
        for (int i = 0; i < 6; ++i) {
            BlockPos blockPos = StargateMilkyWayMergeHelper.INSTANCE.getChevronBlocks().get(i).func_190942_a(FacingToRotation.get(rendererState.facing)).func_177971_a((Vec3i)rendererState.pos);
            skyLight += this.func_178459_a().func_175642_b(EnumSkyBlock.SKY, blockPos);
            blockLight += this.func_178459_a().func_175642_b(EnumSkyBlock.BLOCK, blockPos);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((blockLight /= 6) * 16), (float)((skyLight /= 6) * 16));
    }

    @Override
    protected Map<BlockPos, IBlockState> getMemberBlockStates(StargateAbstractMergeHelper mergeHelper, EnumFacing facing) {
        HashMap<BlockPos, IBlockState> map = new HashMap<BlockPos, IBlockState>();
        for (BlockPos pos : mergeHelper.getRingBlocks()) {
            map.put(pos, mergeHelper.getMemberBlock().func_176223_P().func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.RING)).func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)facing));
        }
        for (BlockPos pos : mergeHelper.getChevronBlocks()) {
            map.put(pos, mergeHelper.getMemberBlock().func_176223_P().func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.CHEVRON)).func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)facing));
        }
        return map;
    }

    protected abstract void renderChevron(S var1, double var2, ChevronEnum var4);

    protected void renderChevrons(S rendererState, double partialTicks) {
        for (ChevronEnum chevron : ChevronEnum.values()) {
            this.renderChevron(rendererState, partialTicks, chevron);
        }
        ((StargateClassicRendererState)rendererState).chevronTextureList.iterate(this.func_178459_a(), partialTicks);
    }

    @Override
    public void renderIris(double partialTicks, World world, S rendererState, boolean backOnly) {
        float irisAnimationStage = world.func_82737_E() - ((StargateClassicRendererState)rendererState).irisAnimation;
        EnumIrisState irisState = ((StargateClassicRendererState)rendererState).irisState;
        EnumIrisType irisType = ((StargateClassicRendererState)rendererState).irisType;
        if (irisType == null || irisState == null) {
            Aunis.logger.debug("Iris state/type was null");
            return;
        }
        if (irisState == EnumIrisState.OPENED) {
            return;
        }
        if (irisType == EnumIrisType.SHIELD) {
            int k;
            if ((irisAnimationStage *= 0.07f) > 0.7f) {
                irisAnimationStage = 0.7f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING) {
                irisAnimationStage = 0.7f - irisAnimationStage;
            }
            GlStateManager.func_179094_E();
            Texture irisTexture = TextureLoader.getTexture(SHIELD_TEXTURE);
            if (irisTexture != null) {
                irisTexture.bindTexture();
            }
            float tick = (float)((double)this.func_178459_a().func_82737_E() + partialTicks);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.13);
            int n = k = backOnly ? 1 : 0;
            while (k < 2) {
                if (k == 1) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                StargateRendererStatic.innerCircle.render(tick, false, Float.valueOf(irisAnimationStage), 0.0f, (byte)-1);
                for (StargateRendererStatic.QuadStrip strip : StargateRendererStatic.quadStrips) {
                    strip.render(tick, false, Float.valueOf(irisAnimationStage), 0.0f, (byte)-1);
                }
                ++k;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if ((irisType == EnumIrisType.IRIS_TITANIUM || irisType == EnumIrisType.IRIS_TRINIUM) && backOnly) {
            if ((irisAnimationStage *= 0.028333334f) > 1.7f) {
                irisAnimationStage = 1.7f;
            }
            if (irisAnimationStage < 0.0f) {
                irisAnimationStage = 0.0f;
            }
            if (irisState == EnumIrisState.OPENING) {
                irisAnimationStage = 1.7f - irisAnimationStage;
            }
            for (float i = 0.0f; i < 20.0f; i += 1.0f) {
                float rotateIndex = 18.0f * i;
                GlStateManager.func_179094_E();
                ElementEnum.IRIS.bindTexture(((StargateClassicRendererState)rendererState).getBiomeOverlay());
                GlStateManager.func_179114_b((float)rotateIndex, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)(-irisAnimationStage), (double)(-(irisAnimationStage * 2.0f)), (double)0.02);
                ElementEnum.IRIS.render();
                GlStateManager.func_179121_F();
            }
        }
    }
}

