/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.energy;

import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.loader.model.ModelLoader;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.energy.ZPMHubRendererState;
import mrjake.aunis.tileentity.energy.ZPMHubTile;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class ZPMHubRenderer
extends TileEntitySpecialRenderer<ZPMHubTile> {
    public static final long ANIMATION_LENGTH = 20L;
    private static final double Y_MAX = 22.5;
    private static final double Y_MIN = 16.5;

    public void render(ZPMHubTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        ZPMHubRendererState rendererState = te.getRendererStateClient();
        if (rendererState != null) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v()).func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v());
            if (state.func_177230_c() != AunisBlocks.ZPM_HUB) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            double scale = 0.027;
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            GlStateManager.func_179137_b((double)18.0, (double)23.5, (double)20.0);
            ElementEnum.ZPM_HUB.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
            long animationStart = rendererState.animationStart;
            boolean isPutting = rendererState.isPutting;
            int zpmAnimated = rendererState.zpmAnimated;
            long animationStage = te.func_145831_w().func_82737_E() - animationStart;
            for (int i = 0; i < 3; ++i) {
                if (rendererState.lastZPMPower.size() < i + 1) {
                    rendererState.lastZPMPower.add(-1);
                }
                if (rendererState.lastZPMPowerLevel.size() < i + 1) {
                    rendererState.lastZPMPowerLevel.add(0);
                }
                if (te.itemStackHandler.getStackInSlot(i).func_190926_b() && rendererState.lastZPMPower.get(i) == -1 && zpmAnimated != i + 1 || rendererState.lastZPMPower.get(i) == -1 && zpmAnimated != i + 1) continue;
                double zy = 16.5;
                if (zpmAnimated != 0) {
                    double calculated = 6.0 * (double)((float)animationStage / 20.0f);
                    if (isPutting && zpmAnimated == i + 1) {
                        if (animationStage == 5L) {
                            te.initZPMSound(true);
                        }
                        if (animationStage / 20L <= 1L && 22.5 - calculated > 16.5) {
                            zy = 22.5 - calculated;
                        } else {
                            zy = 16.5;
                            te.setZPMStatus(zpmAnimated - 1, true);
                        }
                    } else if (!isPutting && zpmAnimated == i + 1) {
                        if (animationStage == 5L) {
                            te.initZPMSound(false);
                        }
                        if (animationStage / 20L <= 1L && 16.5 + calculated < 22.5) {
                            zy = 16.5 + calculated;
                        } else {
                            zy = 22.5;
                            te.setZPMStatus(zpmAnimated - 1, false);
                        }
                    }
                }
                int powerLevel = rendererState.lastZPMPowerLevel.get(i);
                boolean isActive = zy == 16.5;
                double zx = 0.0;
                double zz = 0.0;
                switch (i) {
                    case 0: {
                        zx = 0.0;
                        zz = -9.25;
                        break;
                    }
                    case 1: {
                        zx = -10.5;
                        zz = 8.75;
                        break;
                    }
                    case 2: {
                        zx = 10.5;
                        zz = 8.75;
                    }
                }
                this.renderZPM(zx, zy, zz, powerLevel, isActive);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void renderZPM(double xx, double xy, double xz, int powerLevel, boolean isActive) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)xx, (double)xy, (double)xz);
        if (powerLevel > 4) {
            powerLevel = 4;
        }
        if (powerLevel < 0) {
            powerLevel = 0;
        }
        this.field_147501_a.field_147553_e.func_110577_a(new ResourceLocation("aunis", "textures/tesr/zpm/item/zpm_" + powerLevel + (isActive ? "_activated" : "") + ".png"));
        ModelLoader.getModel(new ResourceLocation("aunis", "models/tesr/zpm/zpm.obj")).render();
        GlStateManager.func_179121_F();
    }
}

