/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.dialhomedevice;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mrjake.aunis.renderer.activation.Activation;
import mrjake.aunis.renderer.activation.DHDPegasusActivation;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.state.State;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DHDPegasusRendererState
extends State {
    private static final String SYMBOL_TEXTURE_BASE = "textures/tesr/pegasus/symbol";
    private static final String BRB_TEXTURE_BASE = "textures/tesr/pegasus/brb";
    private static final Map<BiomeOverlayEnum, TextureContainer> BIOME_TEXTURE_MAP = new HashMap<BiomeOverlayEnum, TextureContainer>();
    public BlockPos pos;
    public float horizontalRotation;
    private BiomeOverlayEnum biomeOverlay;
    private final Map<SymbolPegasusEnum, Integer> BUTTON_STATE_MAP = new HashMap<SymbolPegasusEnum, Integer>(38);
    public List<Activation<SymbolPegasusEnum>> activationList = new ArrayList<Activation<SymbolPegasusEnum>>();
    public StargateAddressDynamic addressDialed;
    public boolean brbActive;
    public BiomeOverlayEnum biomeOverride;

    public DHDPegasusRendererState() {
    }

    public DHDPegasusRendererState(StargateAddressDynamic addressDialed, boolean brbActive, BiomeOverlayEnum biomeOverride) {
        this.addressDialed = addressDialed;
        this.brbActive = brbActive;
        this.biomeOverride = biomeOverride;
    }

    public DHDPegasusRendererState initClient(BlockPos pos, float horizontalRotation, BiomeOverlayEnum biomeOverlay) {
        this.pos = pos;
        this.horizontalRotation = horizontalRotation;
        this.biomeOverlay = biomeOverlay;
        for (SymbolPegasusEnum symbol : SymbolPegasusEnum.values()) {
            if (symbol.brb()) {
                this.BUTTON_STATE_MAP.put(symbol, this.brbActive ? 5 : 0);
                continue;
            }
            this.BUTTON_STATE_MAP.put(symbol, this.addressDialed.contains(symbol) ? 5 : 0);
        }
        return this;
    }

    public BiomeOverlayEnum getBiomeOverlay() {
        if (this.biomeOverride != null) {
            return this.biomeOverride;
        }
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayEnum biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    private boolean isSymbolActiveClientSide(SymbolPegasusEnum symbol) {
        return this.BUTTON_STATE_MAP.get(symbol) != 0;
    }

    public void clearSymbols(long totalWorldTime) {
        for (SymbolPegasusEnum symbol : SymbolPegasusEnum.values()) {
            if (!this.isSymbolActiveClientSide(symbol)) continue;
            this.activationList.add(new DHDPegasusActivation(symbol, totalWorldTime, true));
        }
    }

    public void activateSymbol(long totalWorldTime, SymbolPegasusEnum symbol) {
        this.activationList.add(new DHDPegasusActivation(symbol, totalWorldTime, false));
    }

    public void iterate(World world, double partialTicks) {
        Activation.iterate(this.activationList, world.func_82737_E(), partialTicks, (index, stage) -> this.BUTTON_STATE_MAP.put((SymbolPegasusEnum)index, Math.round(stage)));
    }

    public ResourceLocation getButtonTexture(SymbolPegasusEnum symbol, BiomeOverlayEnum biomeOverlay) {
        TextureContainer container = BIOME_TEXTURE_MAP.get((Object)biomeOverlay);
        if (symbol.brb()) {
            return container.BRB_RESOURCE_MAP.get(this.BUTTON_STATE_MAP.get(symbol));
        }
        return container.SYMBOL_RESOURCE_MAP.get(this.BUTTON_STATE_MAP.get(symbol));
    }

    @Override
    public void toBytes(ByteBuf buf) {
        this.addressDialed.toBytes(buf);
        buf.writeBoolean(this.brbActive);
        if (this.biomeOverride != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.biomeOverride.ordinal());
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.addressDialed = new StargateAddressDynamic(SymbolTypeEnum.PEGASUS);
        this.addressDialed.fromBytes(buf);
        this.brbActive = buf.readBoolean();
        if (buf.readBoolean()) {
            this.biomeOverride = BiomeOverlayEnum.values()[buf.readInt()];
        }
    }

    static {
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            TextureContainer container = new TextureContainer();
            for (int i = 0; i <= 5; ++i) {
                container.SYMBOL_RESOURCE_MAP.put(i, new ResourceLocation("aunis", SYMBOL_TEXTURE_BASE + i + biomeOverlay.suffix + ".png"));
                container.BRB_RESOURCE_MAP.put(i, new ResourceLocation("aunis", BRB_TEXTURE_BASE + i + biomeOverlay.suffix + ".jpg"));
            }
            BIOME_TEXTURE_MAP.put(biomeOverlay, container);
        }
    }

    private static class TextureContainer {
        public final Map<Integer, ResourceLocation> SYMBOL_RESOURCE_MAP = new HashMap<Integer, ResourceLocation>();
        public final Map<Integer, ResourceLocation> BRB_RESOURCE_MAP = new HashMap<Integer, ResourceLocation>();

        private TextureContainer() {
        }
    }
}

