/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.renderer.biomes;

import java.util.EnumSet;
import mrjake.aunis.Aunis;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.util.BlockHelpers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public enum BiomeOverlayEnum {
    NORMAL("", TextFormatting.GRAY),
    FROST("_frost", TextFormatting.DARK_AQUA),
    MOSSY("_mossy", TextFormatting.DARK_GREEN),
    AGED("_aged", TextFormatting.GRAY),
    SOOTY("_sooty", TextFormatting.DARK_GRAY);

    public String suffix;
    private TextFormatting color;
    private String unlocalizedName;

    private BiomeOverlayEnum(String suffix, TextFormatting color) {
        this.suffix = suffix;
        this.color = color;
        this.unlocalizedName = "gui.stargate.biome_overlay." + this.name().toLowerCase();
    }

    public String getLocalizedColorizedName() {
        return this.color + Aunis.proxy.localize(this.unlocalizedName, new Object[0]);
    }

    public static BiomeOverlayEnum updateBiomeOverlay(World world, BlockPos topmostBlock, EnumSet<BiomeOverlayEnum> supportedOverlays) {
        BiomeOverlayEnum ret = BiomeOverlayEnum.getBiomeOverlay(world, topmostBlock);
        if (supportedOverlays.contains((Object)ret)) {
            return ret;
        }
        return NORMAL;
    }

    private static BiomeOverlayEnum getBiomeOverlay(World world, BlockPos topmostBlock) {
        Biome biome = world.func_180494_b(topmostBlock);
        if (world.field_73011_w.func_186058_p() != DimensionType.NETHER && !BlockHelpers.isBlockDirectlyUnderSky((IBlockAccess)world, topmostBlock)) {
            return NORMAL;
        }
        if (biome.func_180626_a(topmostBlock) <= AunisConfig.stargateConfig.frostyTemperatureThreshold) {
            return FROST;
        }
        BiomeOverlayEnum overlay = AunisConfig.stargateConfig.getBiomeOverrideBiomes().get(biome);
        if (overlay != null) {
            return overlay;
        }
        return NORMAL;
    }

    public static BiomeOverlayEnum fromString(String name) {
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            if (!biomeOverlay.toString().equals(name)) continue;
            return biomeOverlay;
        }
        return null;
    }
}

