/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ParticleBlender {
    private SimpleVector pos;
    private float y;
    private int moduloTicks;
    private int moduloTicksSlower;
    private float motionX;
    private float motionZ;
    private boolean falling;
    private RandomizeInterface randomize;

    public ParticleBlender(float x, float y, float z, int moduloTicks, int moduloTicksSlower, float motionX, float motionZ, boolean falling, RandomizeInterface randomize) {
        this.pos = new SimpleVector(x * 0.43f, -y * 0.43f);
        this.y = z * 0.43f;
        this.moduloTicks = moduloTicks;
        this.moduloTicksSlower = moduloTicksSlower;
        this.motionX = motionX;
        this.motionZ = motionZ;
        this.falling = falling;
        this.randomize = randomize;
    }

    public ParticleBlender(float x, float y, float z, int moduloTicks, int moduloTicksSlower, boolean falling, RandomizeInterface randomize) {
        this(x, y, z, moduloTicks, moduloTicksSlower, 0.0f, 0.0f, falling, randomize);
    }

    public int getModuloTicks(boolean slower) {
        return slower ? this.moduloTicksSlower : this.moduloTicks;
    }

    public void spawn(World world, BlockPos pos, float horizontalRotation, boolean slower) {
        if (world.func_82737_E() % (long)this.getModuloTicks(slower) != 0L) {
            return;
        }
        SimpleVector position = this.pos.rotate((int)horizontalRotation);
        SimpleVector motion = new SimpleVector(this.motionX, this.motionZ);
        if (this.randomize != null) {
            this.randomize.randomize(motion);
        }
        motion = motion.rotate((int)horizontalRotation);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(this.createParticle(world, position.x + (double)pos.func_177958_n() + 0.5, this.y + (float)pos.func_177956_o(), position.z + (double)pos.func_177952_p() + 0.5, motion.x, motion.z, this.falling));
    }

    protected abstract Particle createParticle(World var1, double var2, float var4, double var5, double var7, double var9, boolean var11);

    public static interface RandomizeInterface {
        public void randomize(SimpleVector var1);
    }

    public static class SimpleVector {
        public double x;
        public double z;

        public SimpleVector(double x, double z) {
            this.x = x;
            this.z = z;
        }

        public SimpleVector rotate(int rotation) {
            switch (rotation) {
                case 90: {
                    return new SimpleVector(this.z, -this.x);
                }
                case 180: {
                    return new SimpleVector(-this.x, -this.z);
                }
                case 270: {
                    return new SimpleVector(-this.z, this.x);
                }
            }
            return this;
        }

        public SimpleVector offset(BlockPos pos) {
            return new SimpleVector(this.x + (double)pos.func_177958_n(), this.z + (double)pos.func_177952_p());
        }

        public String toString() {
            return "[" + this.x + ", " + this.z + "]";
        }
    }
}

