/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet.transportrings;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.packet.PositionedPacket;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.stargate.EnumScheduledTask;
import mrjake.aunis.tileentity.transportrings.TRControllerAbstractTile;
import mrjake.aunis.tileentity.transportrings.TransportRingsAbstractTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TRControllerActivatedToServer
extends PositionedPacket {
    public int address;

    public TRControllerActivatedToServer() {
    }

    public TRControllerActivatedToServer(BlockPos pos, int address) {
        super(pos);
        this.address = address;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.address);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.address = buf.readInt();
    }

    public static class TRControllerActivatedServerHandler
    implements IMessageHandler<TRControllerActivatedToServer, IMessage> {
        public IMessage onMessage(TRControllerActivatedToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                TRControllerAbstractTile controllerTile = (TRControllerAbstractTile)world.func_175625_s(message.pos);
                TransportRingsAbstractTile ringsTile = controllerTile.getLinkedRingsTile((World)world);
                if (ringsTile != null) {
                    AunisSoundHelper.playSoundEvent((World)world, message.pos, SoundEventEnum.RINGS_CONTROLLER_BUTTON);
                    ringsTile.attemptTransportTo(message.address, EnumScheduledTask.RINGS_START_ANIMATION.waitTicks).sendMessageIfFailed((EntityPlayer)player);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.transportrings_controller_block.not_linked", new Object[0]), true);
                }
            });
            return null;
        }
    }
}

