/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet.transportrings;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.PositionedPacket;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.tileentity.transportrings.TransportRingsAbstractTile;
import mrjake.aunis.transportrings.ParamsSetResult;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SaveRingsParametersToServer
extends PositionedPacket {
    int address;
    String name;

    public SaveRingsParametersToServer() {
    }

    public SaveRingsParametersToServer(BlockPos pos, int address, String name) {
        super(pos);
        this.address = address;
        this.name = name;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.address);
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.address = buf.readInt();
        int len = buf.readInt();
        this.name = buf.readCharSequence(len, StandardCharsets.UTF_8).toString();
    }

    public static class SaveRingsParametersServerHandler
    implements IMessageHandler<SaveRingsParametersToServer, IMessage> {
        public StateUpdatePacketToClient onMessage(SaveRingsParametersToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(message.pos);
                if (ringsTile.setRingsParams(message.address, message.name) == ParamsSetResult.DUPLICATE_ADDRESS) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.transportrings_block.duplicate_address", new Object[0]), true);
                }
                AunisPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(message.pos, StateTypeEnum.GUI_STATE, ringsTile.getState(StateTypeEnum.GUI_STATE)), player);
            });
            return null;
        }
    }
}

