/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet.stargate;

import io.netty.buffer.ByteBuf;
import javax.vecmath.Vector2f;
import mrjake.aunis.AunisProps;
import mrjake.aunis.packet.PositionedPacket;
import mrjake.aunis.stargate.teleportation.TeleportHelper;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StargateMotionToServer
extends PositionedPacket {
    private int entityId;
    private float motionX;
    private float motionZ;

    public StargateMotionToServer() {
    }

    public StargateMotionToServer(int entityId, BlockPos pos, float motionX, float motionZ) {
        super(pos);
        this.entityId = entityId;
        this.motionX = motionX;
        this.motionZ = motionZ;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.entityId);
        buf.writeFloat(this.motionX);
        buf.writeFloat(this.motionZ);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.entityId = buf.readInt();
        this.motionX = buf.readFloat();
        this.motionZ = buf.readFloat();
    }

    public static class MotionServerHandler
    implements IMessageHandler<StargateMotionToServer, IMessage> {
        public IMessage onMessage(StargateMotionToServer message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                EnumFacing sourceFacing = (EnumFacing)world.func_180495_p(message.pos).func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL);
                StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(message.pos);
                Vector2f motionVector = new Vector2f(message.motionX, message.motionZ);
                if (TeleportHelper.frontSide(sourceFacing, motionVector)) {
                    gateTile.setMotionOfPassingEntity(message.entityId, motionVector);
                    gateTile.teleportEntity(message.entityId);
                } else {
                    gateTile.removeEntity(message.entityId);
                }
            });
            return null;
        }
    }
}

