/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet.stargate;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.PositionedPacket;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.stargate.EnumIrisMode;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SaveIrisCodeToServer
extends PositionedPacket {
    int code;
    EnumIrisMode mode;

    public SaveIrisCodeToServer() {
    }

    public SaveIrisCodeToServer(BlockPos pos, int code, EnumIrisMode mode) {
        super(pos);
        this.code = code;
        this.mode = mode;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.code);
        buf.writeByte((int)this.mode.id);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.code = buf.readInt();
        this.mode = EnumIrisMode.getValue(buf.readByte());
    }

    public static class SaveIrisCodeToServerHandler
    implements IMessageHandler<SaveIrisCodeToServer, IMessage> {
        public StateUpdatePacketToClient onMessage(SaveIrisCodeToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                if (world.func_175625_s(message.pos) instanceof StargateClassicBaseTile) {
                    StargateClassicBaseTile te = (StargateClassicBaseTile)world.func_175625_s(message.pos);
                    te.setIrisCode(message.code);
                    te.setIrisMode(message.mode);
                    AunisPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(message.pos, StateTypeEnum.GUI_STATE, te.getState(StateTypeEnum.GUI_STATE)), player);
                }
            });
            return null;
        }
    }
}

