/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet.stargate;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.packet.PositionedPacket;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.StargateClosedReasonEnum;
import mrjake.aunis.stargate.StargateOpenResult;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.tileentity.dialhomedevice.DHDPegasusTile;
import mrjake.aunis.tileentity.stargate.StargatePegasusBaseTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DHDPegasusButtonClickedToServer
extends PositionedPacket {
    public SymbolPegasusEnum symbol;
    public boolean force;

    public DHDPegasusButtonClickedToServer() {
    }

    public DHDPegasusButtonClickedToServer(BlockPos pos, SymbolPegasusEnum symbol) {
        super(pos);
        this.symbol = symbol;
    }

    public DHDPegasusButtonClickedToServer(BlockPos pos, SymbolPegasusEnum symbol, boolean force) {
        super(pos);
        this.symbol = symbol;
        this.force = force;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.symbol.id);
        buf.writeBoolean(this.force);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.symbol = SymbolPegasusEnum.valueOf(buf.readInt());
        this.force = buf.readBoolean();
    }

    public static class DHDPegasusButtonClickedServerHandler
    implements IMessageHandler<DHDPegasusButtonClickedToServer, IMessage> {
        public IMessage onMessage(DHDPegasusButtonClickedToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            if (world.func_175625_s(message.pos) instanceof DHDPegasusTile) {
                world.func_152344_a(() -> {
                    DHDPegasusTile dhdTile = (DHDPegasusTile)world.func_175625_s(message.pos);
                    if (((IItemHandler)dhdTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0).func_190926_b()) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.dhd_block.no_crystal_warn", new Object[0]), true);
                        return;
                    }
                    if (!dhdTile.isLinked()) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.dhd_block.not_linked_warn", new Object[0]), true);
                        return;
                    }
                    StargatePegasusBaseTile gateTile = (StargatePegasusBaseTile)dhdTile.getLinkedGate((IBlockAccess)world);
                    EnumStargateState gateState = gateTile.getStargateState();
                    if (gateState.engaged() && message.symbol.brb()) {
                        if (gateState.initiating()) {
                            gateTile.attemptClose(StargateClosedReasonEnum.REQUESTED);
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.dhd_block.incoming_wormhole_warn", new Object[0]), true);
                        }
                    } else if (message.force && message.symbol.brb()) {
                        StargateOpenResult openResult = gateTile.attemptOpenAndFail();
                        if (openResult == StargateOpenResult.NOT_ENOUGH_POWER) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.stargatebase_block.not_enough_power", new Object[0]), true);
                        }
                    } else if ((gateState.idle() || gateState.dialing()) && !gateState.dialingComputer()) {
                        if (message.symbol.brb()) {
                            gateTile.addSymbolToAddressDHD(message.symbol, (EntityPlayer)player);
                        } else if (gateTile.canAddSymbol(message.symbol)) {
                            gateTile.addSymbolToAddressDHD(message.symbol, (EntityPlayer)player);
                        }
                    }
                });
            }
            return null;
        }
    }
}

