/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet.gui.entry;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import mrjake.aunis.item.dialer.UniverseDialerItem;
import mrjake.aunis.item.dialer.UniverseDialerMode;
import mrjake.aunis.packet.gui.entry.OCActionEnum;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class OCActionToServer
implements IMessage {
    private EnumHand hand;
    private OCActionEnum action;
    private int index;
    private String string;

    public OCActionToServer() {
    }

    public OCActionToServer(EnumHand hand, OCActionEnum action, int index, String string) {
        this.hand = hand;
        this.action = action;
        this.index = index;
        this.string = string;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.hand.ordinal());
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.index);
        buf.writeInt(this.string.length());
        buf.writeCharSequence((CharSequence)this.string, StandardCharsets.UTF_8);
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = EnumHand.values()[buf.readInt()];
        this.action = OCActionEnum.values()[buf.readInt()];
        this.index = buf.readInt();
        int size = buf.readInt();
        this.string = buf.readCharSequence(size, StandardCharsets.UTF_8).toString();
    }

    public static class OCActionServerHandler
    implements IMessageHandler<OCActionToServer, IMessage> {
        public IMessage onMessage(OCActionToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                ItemStack stack = player.func_184586_b(message.hand);
                NBTTagCompound compound = stack.func_77978_p();
                NBTTagList list = compound.func_150295_c(UniverseDialerMode.OC.tagListName, 10);
                switch (message.action) {
                    case CHANGE_ADDRESS: {
                        UniverseDialerItem.changeOCMessageAtIndex(list, message.index, ocMessage -> {
                            ocMessage.address = message.string;
                        });
                        break;
                    }
                    case CHANGE_PORT: {
                        UniverseDialerItem.changeOCMessageAtIndex(list, message.index, ocMessage -> {
                            ocMessage.port = (short)Integer.parseInt(message.string);
                        });
                        break;
                    }
                    case CHANGE_PARAMS: {
                        UniverseDialerItem.changeOCMessageAtIndex(list, message.index, ocMessage -> {
                            ocMessage.dataStr = message.string;
                        });
                    }
                }
            });
            return null;
        }
    }
}

