/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.PositionedPacket;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateProviderInterface;
import mrjake.aunis.state.StateTypeEnum;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import scala.NotImplementedError;

public class StateUpdateRequestToServer
extends PositionedPacket {
    StateTypeEnum stateType;

    public StateUpdateRequestToServer() {
    }

    public StateUpdateRequestToServer(BlockPos pos, StateTypeEnum stateType) {
        super(pos);
        this.stateType = stateType;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.stateType.id);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.stateType = StateTypeEnum.byId(buf.readInt());
    }

    public static class StateUpdateServerHandler
    implements IMessageHandler<StateUpdateRequestToServer, IMessage> {
        public StateUpdatePacketToClient onMessage(StateUpdateRequestToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            if (world.func_175667_e(message.pos)) {
                world.func_152344_a(() -> {
                    StateProviderInterface te = (StateProviderInterface)world.func_175625_s(message.pos);
                    if (te != null) {
                        try {
                            State state = te.getState(message.stateType);
                            if (state == null) {
                                throw new NotImplementedError("State not implemented on " + te.toString() + " : " + message.stateType.toString());
                            }
                            AunisPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(message.pos, message.stateType, state), player);
                        }
                        catch (UnsupportedOperationException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return null;
        }
    }
}

