/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.packet;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.Aunis;
import mrjake.aunis.packet.PositionedPacket;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateProviderInterface;
import mrjake.aunis.state.StateTypeEnum;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import scala.NotImplementedError;

public class StateUpdatePacketToClient
extends PositionedPacket {
    private StateTypeEnum stateType;
    private State state;
    private ByteBuf stateBuf;

    public StateUpdatePacketToClient() {
    }

    public StateUpdatePacketToClient(BlockPos pos, StateTypeEnum stateType, State state) {
        super(pos);
        this.stateType = stateType;
        this.state = state;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.stateType.id);
        this.state.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.stateType = StateTypeEnum.byId(buf.readInt());
        this.stateBuf = buf.copy();
    }

    public static class StateUpdateClientHandler
    implements IMessageHandler<StateUpdatePacketToClient, IMessage> {
        public IMessage onMessage(StateUpdatePacketToClient message, MessageContext ctx) {
            EntityPlayer player = Aunis.proxy.getPlayerClientSide();
            World world = player.func_130014_f_();
            Aunis.proxy.addScheduledTaskClientSide(() -> {
                block5: {
                    StateProviderInterface te = (StateProviderInterface)world.func_175625_s(message.pos);
                    try {
                        if (te == null) {
                            return;
                        }
                        State state = te.createState(message.stateType);
                        if (state != null) {
                            state.fromBytes(message.stateBuf);
                            if (te != null) {
                                te.setState(message.stateType, state);
                            }
                            break block5;
                        }
                        throw new NotImplementedError("State not implemented on " + te.toString());
                    }
                    catch (UnsupportedOperationException e) {
                        e.printStackTrace();
                    }
                }
            });
            return null;
        }
    }
}

