/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.loader.texture;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mrjake.aunis.Aunis;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.loader.FolderLoader;
import mrjake.aunis.loader.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.commons.io.IOUtils;

public class TextureLoader {
    public static final String TEXTURES_PATH = "assets/aunis/textures/tesr";
    private static final Map<ResourceLocation, Texture> LOADED_TEXTURES = new HashMap<ResourceLocation, Texture>();

    public static Texture getTexture(ResourceLocation resourceLocation) {
        return LOADED_TEXTURES.get(resourceLocation);
    }

    public static boolean isTextureLoaded(ResourceLocation resourceLocation) {
        return LOADED_TEXTURES.containsKey(resourceLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadTextures(IResourceManager resourceManager) throws IOException {
        for (Texture texture : LOADED_TEXTURES.values()) {
            texture.deleteTexture();
        }
        List<String> texturePaths = FolderLoader.getAllFiles(TEXTURES_PATH, ".png", ".jpg");
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Aunis: Resurrection - Loading textures", (int)texturePaths.size());
        long start = System.currentTimeMillis();
        Aunis.logger.info("Started loading textures...");
        block15: for (String texturePath : texturePaths) {
            texturePath = texturePath.replaceFirst("assets/aunis/", "");
            progressBar.step(texturePath.replaceFirst("textures/", ""));
            if (AunisConfig.stargateConfig.disableAnimatedEventHorizon) {
                switch (texturePath) {
                    case "textures/tesr/event_horizon_animated_unstable.jpg": 
                    case "textures/tesr/event_horizon_animated.jpg": 
                    case "textures/tesr/event_horizon_animated_kawoosh.jpg": 
                    case "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg": {
                        if (!AunisConfig.debugConfig.logTexturesLoading) continue block15;
                        Aunis.logger.info("Skipping: " + texturePath);
                        continue block15;
                    }
                }
            }
            ResourceLocation resourceLocation = new ResourceLocation("aunis", texturePath);
            IResource resource = null;
            try {
                resource = resourceManager.func_110536_a(resourceLocation);
                if (AunisConfig.debugConfig.logTexturesLoading) {
                    Aunis.logger.info("Loading texture: " + texturePath);
                }
                BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
                LOADED_TEXTURES.put(resourceLocation, new Texture(bufferedImage, false));
            }
            catch (IOException e) {
                Aunis.logger.error("Failed to load texture " + texturePath);
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((Closeable)resource);
            }
        }
        Aunis.logger.info("Loaded " + texturePaths.size() + " textures in " + (System.currentTimeMillis() - start) + " ms");
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    public static ResourceLocation getTextureResource(String texture) {
        return new ResourceLocation("aunis", "textures/tesr/" + texture);
    }
}

