/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.loader.texture;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import mrjake.aunis.Aunis;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;

public class Texture {
    private int textureId = TextureUtil.func_110996_a();

    public Texture(BufferedImage bufferedImage, boolean desaturate) {
        if (desaturate) {
            Aunis.logger.info("Started desaturation of the event horizon texture");
            WritableRaster raster = bufferedImage.getRaster();
            int w = raster.getWidth();
            int h = raster.getHeight();
            List<RasterThread> th = Arrays.asList(new RasterThread(0, 0, w / 2, h / 2, raster), new RasterThread(w / 2, 0, w / 2, h / 2, raster), new RasterThread(w / 2, h / 2, w / 2, h / 2, raster), new RasterThread(0, h / 2, w / 2, h / 2, raster));
            for (Thread thread : th) {
                thread.start();
            }
            try {
                th.get(0).join();
                th.get(1).join();
                th.get(2).join();
                th.get(3).join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Aunis.logger.info("Finished desaturation of the event horizon texture");
        }
        TextureUtil.func_110989_a((int)this.textureId, (BufferedImage)bufferedImage, (boolean)false, (boolean)false);
    }

    public void deleteTexture() {
        TextureUtil.func_147942_a((int)this.textureId);
    }

    public void bindTexture() {
        GlStateManager.func_179144_i((int)this.textureId);
    }

    private static class RasterThread
    extends Thread {
        private int x;
        private int y;
        private int w;
        private int h;
        private WritableRaster raster;

        public RasterThread(int x, int y, int w, int h, WritableRaster raster) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.raster = raster;
        }

        @Override
        public void run() {
            Aunis.logger.debug(String.format("Starting thread (%d, %d) to (%d, %d)", this.x, this.y, this.x + this.w, this.y + this.h));
            float[] pixel = new float[3];
            for (int w = this.x; w < this.x + this.w; ++w) {
                for (int h = this.y; h < this.y + this.h; ++h) {
                    this.raster.getPixel(w, h, pixel);
                    if (pixel[0] == 0.0f && pixel[1] == 0.0f && pixel[2] == 0.0f) continue;
                    float gray = 0.0f;
                    gray = (float)((double)gray + (double)pixel[0] * 0.299);
                    gray = (float)((double)gray + (double)pixel[1] * 0.587);
                    pixel[0] = gray = (float)((double)gray + (double)pixel[2] * 0.114);
                    pixel[1] = gray;
                    pixel[2] = gray;
                    this.raster.setPixel(w, h, pixel);
                }
            }
            Aunis.logger.debug(String.format("Finished thread (%d, %d) to (%d, %d)", this.x, this.y, this.x + this.w, this.y + this.h));
        }
    }
}

