/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mrjake.aunis.Aunis;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.loader.model.ModelLoader;
import mrjake.aunis.loader.texture.TextureLoader;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import net.minecraft.util.ResourceLocation;

public enum ElementEnum {
    MILKYWAY_GATE_MAINMENU("mainmenu/gate.obj", "mainmenu/gatering7"),
    MILKYWAY_RING_MAINMENU("mainmenu/ring.obj", "mainmenu/gatering7"),
    MILKYWAY_CHEVRON_LIGHT_MAINMENU("mainmenu/chevronLight.obj", "mainmenu/chevron0"),
    MILKYWAY_CHEVRON_FRAME_MAINMENU("mainmenu/chevronFrame.obj", "mainmenu/gatering7"),
    MILKYWAY_CHEVRON_MOVING_MAINMENU("mainmenu/chevronMoving.obj", "mainmenu/chevron0"),
    MILKYWAY_CHEVRON_LIGHT_ACTIVE_MAINMENU("mainmenu/chevronLight.obj", "mainmenu/chevron10"),
    MILKYWAY_CHEVRON_MOVING_ACTIVE_MAINMENU("mainmenu/chevronMoving.obj", "mainmenu/chevron10"),
    MILKYWAY_DHD("milkyway/DHD.obj", "milkyway/dhd"),
    MILKYWAY_GATE("milkyway/gate.obj", "milkyway/gatering7"),
    MILKYWAY_RING("milkyway/ring.obj", "milkyway/gatering7"),
    MILKYWAY_CHEVRON_LIGHT("milkyway/chevronLight.obj", "milkyway/chevron0"),
    MILKYWAY_CHEVRON_FRAME("milkyway/chevronFrame.obj", "milkyway/gatering7"),
    MILKYWAY_CHEVRON_MOVING("milkyway/chevronMoving.obj", "milkyway/chevron0"),
    MILKYWAY_CHEVRON_BACK("milkyway/chevronBack.obj", "milkyway/gatering7"),
    ORLIN_GATE("orlin/gate_orlin.obj", "orlin/gate_orlin"),
    UNIVERSE_GATE("universe/universe_gate.obj", "universe/universe_gate"),
    UNIVERSE_CHEVRON("universe/universe_chevron.obj", "universe/universe_chevron10"),
    UNIVERSE_DIALER("universe/universe_dialer.obj", "universe/universe_dialer"),
    UNIVERSE_DIALER_BROKEN("universe/universe_dialer.obj", "universe/universe_dialer_broken"),
    PEGASUS_DHD("pegasus/DHD.obj", "pegasus/dhd"),
    PEGASUS_GATE("pegasus/gate.obj", "pegasus/gatering7"),
    PEGASUS_RING("pegasus/ring_atlantis.obj", "pegasus/gatering7"),
    PEGASUS_CHEVRON_LIGHT("pegasus/chevronLight.obj", "pegasus/chevron0"),
    PEGASUS_CHEVRON_FRAME("pegasus/chevronFrame.obj", "pegasus/gatering7"),
    PEGASUS_CHEVRON_MOVING("pegasus/chevronMoving.obj", "pegasus/chevron0"),
    PEGASUS_CHEVRON_BACK("pegasus/chevronBack.obj", "pegasus/gatering7"),
    RINGS_BLACK("transportrings/rings_black.obj", "transportrings/rings_black"),
    RINGSCONTROLLER_GOAULD("transportrings/plate_goauld.obj", "transportrings/goauld_panel"),
    RINGSCONTROLLER_GOAULD_BUTTONS("transportrings/buttons_goauld.obj", "transportrings/goauld_buttons"),
    ZPM_HUB("zpm/zpmhub.obj", "zpm/hub/zpmhub"),
    SHIELD("iris/shield.obj", "iris/shield"),
    IRIS("iris/iris_blade.obj", "iris/iris_blade"),
    GDO("iris/gdo.obj", "iris/gdo.png");

    public ResourceLocation modelResource;
    public Map<BiomeOverlayEnum, ResourceLocation> biomeTextureResourceMap = new HashMap<BiomeOverlayEnum, ResourceLocation>();
    private List<BiomeOverlayEnum> nonExistingReported = new ArrayList<BiomeOverlayEnum>();

    private ElementEnum(String model, String texture) {
        if (model.startsWith("mainmenu/") && AunisConfig.mainMenuConfig.disableAunisMainMenu) {
            this.modelResource = null;
            return;
        }
        this.modelResource = ModelLoader.getModelResource(model);
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            if (texture.endsWith(".png")) {
                this.biomeTextureResourceMap.put(biomeOverlay, TextureLoader.getTextureResource(texture));
                continue;
            }
            this.biomeTextureResourceMap.put(biomeOverlay, TextureLoader.getTextureResource(texture + biomeOverlay.suffix + ".jpg"));
        }
    }

    public void render() {
        ModelLoader.getModel(this.modelResource).render();
    }

    public void bindTexture(BiomeOverlayEnum biomeOverlay) {
        ResourceLocation resourceLocation = this.biomeTextureResourceMap.get((Object)biomeOverlay);
        if (!TextureLoader.isTextureLoaded(resourceLocation)) {
            if (!this.nonExistingReported.contains((Object)biomeOverlay)) {
                Aunis.logger.error((Object)((Object)this) + " tried to use BiomeOverlay " + (Object)((Object)biomeOverlay) + " but it doesn't exist. (" + resourceLocation + ")");
                this.nonExistingReported.add(biomeOverlay);
            }
            resourceLocation = this.biomeTextureResourceMap.get((Object)BiomeOverlayEnum.NORMAL);
        }
        TextureLoader.getTexture(resourceLocation).bindTexture();
    }

    public void bindTextureAndRender(BiomeOverlayEnum biomeOverlay) {
        this.bindTexture(biomeOverlay);
        this.render();
    }
}

