/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item.oc;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.dialer.UniverseDialerMode;
import mrjake.aunis.item.oc.ItemOCMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketWindowItems;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ItemOCProgramToServer
implements IMessage {
    private EnumHand hand;
    private ItemOCMessage message;

    public ItemOCProgramToServer() {
    }

    public ItemOCProgramToServer(EnumHand hand, ItemOCMessage message) {
        this.hand = hand;
        this.message = message;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.hand == EnumHand.MAIN_HAND ? 0 : 1);
        buf.writeShort((int)this.message.port);
        ItemOCProgramToServer.writeString(buf, this.message.name);
        ItemOCProgramToServer.writeString(buf, this.message.address);
        ItemOCProgramToServer.writeString(buf, this.message.dataStr);
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readInt() == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        short port = buf.readShort();
        String name = ItemOCProgramToServer.readString(buf);
        String address = ItemOCProgramToServer.readString(buf);
        String data = ItemOCProgramToServer.readString(buf);
        this.message = new ItemOCMessage(name, address, port, data);
    }

    private static void writeString(ByteBuf buf, String string) {
        buf.writeInt(string.length());
        buf.writeCharSequence((CharSequence)string, StandardCharsets.UTF_8);
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        return buf.readCharSequence(len, StandardCharsets.UTF_8).toString();
    }

    public static class ItemOCProgramServerHandler
    implements IMessageHandler<ItemOCProgramToServer, IMessage> {
        public IMessage onMessage(ItemOCProgramToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                ItemStack stack = player.func_184586_b(message.hand);
                if ((stack.func_77973_b() == AunisItems.UNIVERSE_DIALER || stack.func_77973_b() == AunisItems.GDO) && stack.func_77942_o()) {
                    NBTTagCompound compound = stack.func_77978_p();
                    NBTTagList ocList = compound.func_150295_c(UniverseDialerMode.OC.tagListName, 10);
                    ocList.func_74742_a((NBTBase)message.message.serializeNBT());
                    compound.func_74782_a(UniverseDialerMode.OC.tagListName, (NBTBase)ocList);
                    player.field_71135_a.func_147359_a((Packet)new SPacketWindowItems(player.field_71071_by.func_184429_b(stack), NonNullList.func_193580_a((Object)stack, (Object[])new ItemStack[0])));
                }
            });
            return null;
        }
    }
}

