/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item.notebook;

import java.util.List;
import mrjake.aunis.Aunis;
import mrjake.aunis.item.notebook.PageNotebookTEISR;
import mrjake.aunis.item.renderer.CustomModel;
import mrjake.aunis.item.renderer.CustomModelItemInterface;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageNotebookItem
extends Item
implements CustomModelItemInterface {
    public static final String ITEM_NAME = "page_notebook";
    private CustomModel customModel;
    private static final String UNNAMED = "item.aunis.notebook.unnamed";

    public PageNotebookItem() {
        this.setRegistryName("aunis:page_notebook");
        this.func_77655_b("aunis.page_notebook");
        this.func_77637_a(Aunis.aunisItemsCreativeTab);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    public ItemCameraTransforms.TransformType getLastTransform() {
        return this.customModel.lastTransform;
    }

    @Override
    public void registerCustomModel(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(this.getRegistryName() + "_filled", "inventory");
        IBakedModel defaultModel = (IBakedModel)registry.func_82594_a((Object)modelResourceLocation);
        this.customModel = new CustomModel(defaultModel);
        registry.func_82595_a((Object)modelResourceLocation, (Object)this.customModel);
    }

    @Override
    public void setCustomModelLocation() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_empty", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_filled", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntityItemStackRenderer createTEISR() {
        return new PageNotebookTEISR();
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77952_i() == 0) {
            tooltip.add(Aunis.proxy.localize("item.aunis.page_mysterious.empty", new Object[0]));
        } else if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            SymbolTypeEnum symbolType = SymbolTypeEnum.valueOf(compound.func_74762_e("symbolType"));
            StargateAddress stargateAddress = new StargateAddress(compound.func_74775_l("address"));
            int maxSymbols = symbolType.getMaxSymbolsDisplay(compound.func_74767_n("hasUpgrade"));
            for (int i = 0; i < maxSymbols; ++i) {
                tooltip.add(TextFormatting.ITALIC + "" + (i > 5 ? TextFormatting.DARK_PURPLE : TextFormatting.AQUA) + stargateAddress.get(i).localize());
            }
        }
    }

    public static int getColorForBiome(String registryPath) {
        int color = 0x303000;
        if (registryPath.contains("ocean") || registryPath.contains("river")) {
            color = 2175392;
        } else if (registryPath.contains("plains")) {
            color = 4747325;
        } else if (registryPath.contains("desert") || registryPath.contains("beach")) {
            color = 10198126;
        } else if (registryPath.contains("extreme_hills")) {
            color = 7561552;
        } else if (registryPath.contains("forest")) {
            color = 5272385;
        } else if (registryPath.contains("taiga")) {
            color = 8104361;
        } else if (registryPath.contains("swamp")) {
            color = 7041847;
        } else if (registryPath.contains("hell")) {
            color = 9841163;
        } else if (registryPath.contains("sky")) {
            color = 6785402;
        } else if (registryPath.contains("ice")) {
            color = 6928582;
        } else if (registryPath.contains("mushroom")) {
            color = 5524301;
        } else if (registryPath.contains("jungle")) {
            color = 0x104004;
        } else if (registryPath.contains("savanna")) {
            color = 0x66622D;
        } else if (registryPath.contains("mesa")) {
            color = 8405271;
        }
        return color;
    }

    public static String getRegistryPathFromWorld(World world, BlockPos pos) {
        return world.func_180494_b(pos).getRegistryName().func_110623_a();
    }

    public static NBTTagCompound getCompoundFromAddress(StargateAddress address, boolean hasUpgrade, String registryPath) {
        NBTTagCompound compound = new NBTTagCompound();
        if (address != null) {
            if (address.getSymbolType() != null) {
                compound.func_74768_a("symbolType", address.getSymbolType().id);
            }
            if (address.serializeNBT() != null) {
                compound.func_74782_a("address", (NBTBase)address.serializeNBT());
            }
        }
        compound.func_74757_a("hasUpgrade", hasUpgrade);
        compound.func_74768_a("color", PageNotebookItem.getColorForBiome(registryPath));
        return compound;
    }

    public static String getUnnamedLocalized() {
        return Aunis.proxy.localize(UNNAMED, new Object[0]);
    }

    public static void setName(NBTTagCompound page, String name) {
        NBTTagCompound display = new NBTTagCompound();
        display.func_74778_a("Name", name);
        page.func_74782_a("display", (NBTBase)display);
    }

    public static String getNameFromCompound(NBTTagCompound compound) {
        NBTTagCompound display;
        if (compound.func_74764_b("display") && (display = compound.func_74775_l("display")).func_74764_b("Name")) {
            return display.func_74779_i("Name");
        }
        return PageNotebookItem.getUnnamedLocalized();
    }
}

