/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item.gdo;

import mrjake.aunis.Aunis;
import mrjake.aunis.capability.endpoint.ItemEndpointCapability;
import mrjake.aunis.capability.endpoint.ItemEndpointInterface;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.gdo.GDOCapabilityProvider;
import mrjake.aunis.item.gdo.GDOMode;
import mrjake.aunis.item.gdo.GDOTEISR;
import mrjake.aunis.item.oc.ItemOCMessage;
import mrjake.aunis.item.renderer.CustomModel;
import mrjake.aunis.item.renderer.CustomModelItemInterface;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GDOItem
extends Item
implements CustomModelItemInterface {
    public static final String ITEM_NAME = "gdo";
    private CustomModel customModel;

    public GDOItem() {
        this.setRegistryName(new ResourceLocation("aunis", ITEM_NAME));
        this.func_77655_b("aunis.gdo");
        this.func_77637_a(Aunis.aunisItemsCreativeTab);
    }

    private static void checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            GDOItem.initNBT(stack);
        }
    }

    private static void initNBT(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("mode", GDOMode.CODE_SENDER.id);
        compound.func_74774_a("selected", (byte)0);
        compound.func_74782_a("saved", (NBTBase)new NBTTagList());
        stack.func_77982_d(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            GDOItem.initNBT(stack);
            items.add((Object)stack);
        }
    }

    @Override
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    public ItemCameraTransforms.TransformType getLastTransform() {
        return this.customModel.lastTransform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntityItemStackRenderer createTEISR() {
        return new GDOTEISR();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new GDOCapabilityProvider();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        block5: {
            block6: {
                GDOMode mode;
                BlockPos pos;
                NBTTagCompound compound;
                block7: {
                    if (world.field_72995_K) break block5;
                    GDOItem.checkNBT(stack);
                    compound = stack.func_77978_p();
                    if (world.func_82737_E() % 20L != 0L || !isSelected) break block6;
                    pos = entity.func_180425_c();
                    int reachSquared = AunisConfig.stargateConfig.universeDialerReach * AunisConfig.stargateConfig.universeDialerReach * 2;
                    mode = GDOMode.valueOf(compound.func_74771_c("mode"));
                    if (!mode.linkable) break block6;
                    if (!compound.func_74764_b(mode.tagPosName)) break block7;
                    BlockPos tilePos = BlockPos.func_177969_a((long)compound.func_74763_f(mode.tagPosName));
                    if (world.func_175625_s(tilePos) != null && world.func_175625_s(tilePos) instanceof StargateAbstractBaseTile && !(tilePos.func_177951_i((Vec3i)pos) > (double)reachSquared)) break block6;
                    compound.func_82580_o(mode.tagPosName);
                    break block6;
                }
                boolean found = false;
                block3: for (BlockPos targetPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-10, -10, -10), (BlockPos)pos.func_177982_a(10, 10, 10))) {
                    if (world.func_175625_s(targetPos) instanceof StargateAbstractBaseTile) {
                        switch (mode) {
                            case CODE_SENDER: 
                            case OC: {
                                StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(targetPos);
                                if (!gateTile.isMerged()) continue block3;
                                compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                                found = true;
                                break;
                            }
                        }
                    }
                    if (!found) continue;
                    break;
                }
            }
            ItemEndpointInterface endpointStack = (ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null);
            endpointStack.checkAndUpdateEndpoint(world.func_82737_E());
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        ((ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null)).removeEndpoint();
        return super.onDroppedByPlayer(stack, player);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            GDOItem.checkNBT(player.func_184586_b(hand));
            NBTTagCompound compound = player.func_184586_b(hand).func_77978_p();
            GDOMode mode = GDOMode.valueOf(compound.func_74771_c("mode"));
            byte selected = compound.func_74771_c("selected");
            if (mode.linkable && !compound.func_74764_b(mode.tagPosName)) {
                return super.func_77659_a(world, player, hand);
            }
            BlockPos linkedPos = BlockPos.func_177969_a((long)compound.func_74763_f(mode.tagPosName));
            switch (mode) {
                case CODE_SENDER: {
                    break;
                }
                case OC: {
                    NBTTagList tagList = compound.func_150295_c(mode.tagListName, 10);
                    NBTTagCompound selectedCompound = tagList.func_150305_b((int)selected);
                    ItemOCMessage message = new ItemOCMessage(selectedCompound);
                    Aunis.logger.debug("Sending OC message: " + message.toString());
                    Aunis.ocWrapper.sendWirelessPacketPlayer(player, player.func_184586_b(hand), message.address, message.port, message.getData());
                    break;
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public static boolean isLinked(ItemStack itemStack) {
        if (itemStack.func_77973_b() == AunisItems.GDO && itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74764_b("linkedGate");
        }
        return false;
    }
}

