/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item.gdo;

import io.netty.buffer.ByteBuf;
import mrjake.aunis.Aunis;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.gdo.GDOActionEnum;
import mrjake.aunis.item.gdo.GDOMode;
import mrjake.aunis.stargate.codesender.PlayerCodeSender;
import mrjake.aunis.stargate.network.StargateNetwork;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GDOActionPacketToServer
implements IMessage {
    private GDOActionEnum action;
    private EnumHand hand;
    private boolean next;
    private int code;

    public GDOActionPacketToServer() {
    }

    public GDOActionPacketToServer(GDOActionEnum action, EnumHand hand, int code, boolean next) {
        this.action = action;
        this.hand = hand;
        this.code = code;
        this.next = next;
    }

    public GDOActionPacketToServer(GDOActionEnum action, EnumHand hand, boolean next) {
        this.action = action;
        this.hand = hand;
        this.code = -1;
        this.next = next;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.hand == EnumHand.MAIN_HAND ? 0 : 1);
        buf.writeInt(this.code);
        buf.writeBoolean(this.next);
    }

    public void fromBytes(ByteBuf buf) {
        this.action = GDOActionEnum.values()[buf.readInt()];
        this.hand = buf.readInt() == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.code = buf.readInt();
        this.next = buf.readBoolean();
    }

    public static class GDOActionPacketServerHandler
    implements IMessageHandler<GDOActionPacketToServer, IMessage> {
        public IMessage onMessage(GDOActionPacketToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                ItemStack stack = player.func_184586_b(message.hand);
                if (stack.func_77973_b() == AunisItems.GDO && stack.func_77942_o()) {
                    NBTTagCompound compound = stack.func_77978_p();
                    GDOMode mode = GDOMode.valueOf(compound.func_74771_c("mode"));
                    switch (message.action) {
                        case SEND_CODE: {
                            if (!compound.func_74764_b("linkedGate")) break;
                            try {
                                BlockPos pos = BlockPos.func_177969_a((long)compound.func_74763_f("linkedGate"));
                                StargateClassicBaseTile gateTile = (StargateClassicBaseTile)world.func_175625_s(pos);
                                if (gateTile == null || gateTile.getDialedAddress() == null) {
                                    return;
                                }
                                StargateAbstractBaseTile targetGate = null;
                                if (!gateTile.getStargateState().initiating() && !gateTile.getStargateState().engaged() || (targetGate = StargateNetwork.get((World)world).getStargate(gateTile.getDialedAddress()).getTileEntity()) == null || !(targetGate instanceof StargateClassicBaseTile)) break;
                                ((StargateClassicBaseTile)targetGate).receiveIrisCode(new PlayerCodeSender((EntityPlayer)player), message.code);
                            }
                            catch (NullPointerException e) {
                                Aunis.logger.error("Exception in GDO Action packet", (Throwable)e);
                            }
                            break;
                        }
                        case MODE_CHANGE: {
                            mode = message.next ? mode.next() : mode.prev();
                            compound.func_74774_a("mode", mode.id);
                            break;
                        }
                        case ADDRESS_CHANGE: {
                            byte selected = compound.func_74771_c("selected");
                            int addressCount = compound.func_150295_c(mode.tagListName, 10).func_74745_c();
                            if (message.next && selected < addressCount - 1) {
                                compound.func_74774_a("selected", (byte)(selected + 1));
                            }
                            if (message.next || selected <= 0) break;
                            compound.func_74774_a("selected", (byte)(selected - 1));
                        }
                    }
                }
            });
            return null;
        }
    }
}

