/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item.dialer;

import java.awt.Color;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.dialer.UniverseDialerItem;
import mrjake.aunis.item.dialer.UniverseDialerMode;
import mrjake.aunis.item.oc.ItemOCMessage;
import mrjake.aunis.item.renderer.AunisFontRenderer;
import mrjake.aunis.item.renderer.ItemRenderHelper;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolMilkyWayEnum;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.stargate.network.SymbolUniverseEnum;
import mrjake.aunis.transportrings.TransportRings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class UniverseDialerTEISR
extends TileEntityItemStackRenderer {
    @SideOnly(value=Side.CLIENT)
    public void func_179022_a(ItemStack stack) {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        ItemCameraTransforms.TransformType transformType = AunisItems.UNIVERSE_DIALER.getLastTransform();
        boolean isBroken = stack.func_77952_i() == UniverseDialerItem.UniverseDialerVariants.BROKEN.meta;
        GlStateManager.func_179094_E();
        if (transformType == ItemCameraTransforms.TransformType.FIXED) {
            GlStateManager.func_179137_b((double)0.53, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
        } else {
            boolean mainhand = AunisItems.UNIVERSE_DIALER.getLastTransform() == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            EnumHandSide handSide = mainhand ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            float angle = ItemRenderHelper.getMapAngleFromPitch(pitch);
            UniverseDialerTEISR.renderArms(handSide, angle, partialTicks);
            angle = 1.0f - angle;
            if (handSide == EnumHandSide.RIGHT) {
                GlStateManager.func_179137_b((double)0.8, (double)0.0, (double)-0.5);
                GlStateManager.func_179114_b((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)0.0, (double)(0.3 * (double)angle), (double)(-0.1 * (double)angle));
                GlStateManager.func_179114_b((float)(25.0f * angle), (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179137_b((double)-0.2, (double)0.0, (double)-0.55);
                GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)(0.3 * (double)angle), (double)(-0.0 * (double)angle));
                GlStateManager.func_179114_b((float)(25.0f * angle), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        }
        if (!isBroken) {
            ElementEnum.UNIVERSE_DIALER.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        } else {
            ElementEnum.UNIVERSE_DIALER_BROKEN.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.1f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        if (stack.func_77942_o() && !isBroken) {
            boolean notLinked;
            NBTTagCompound compound = stack.func_77978_p();
            UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
            UniverseDialerTEISR.drawStringWithShadow(-0.47f, 0.916f, mode.localize(), true, false);
            UniverseDialerTEISR.drawStringWithShadow(0.22f, 0.916f, mode.next().localize(), false, false);
            boolean bl = notLinked = mode.linkable && !compound.func_74764_b(mode.tagPosName);
            if (notLinked) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("aunis", "textures/gui/universe_warning.png"));
                GlStateManager.func_179098_w();
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)0.91f, (float)1.0f, (float)1.0f, (float)1.0f);
                UniverseDialerTEISR.drawTexturedRect(0.72f, 0.26f, 0.0f, 0.24f, 0.24f);
            }
            if (!notLinked || mode == UniverseDialerMode.MEMORY) {
                byte selected = compound.func_74771_c("selected");
                NBTTagList tagList = compound.func_150295_c(mode.tagListName, 10);
                block5: for (int offset = -1; offset <= 1; ++offset) {
                    int index = selected + offset;
                    if (index < 0 || index >= tagList.func_74745_c()) continue;
                    boolean active = offset == 0;
                    NBTTagCompound entryCompound = tagList.func_150305_b(index);
                    switch (mode) {
                        case MEMORY: 
                        case NEARBY: {
                            boolean engage_poo;
                            UniverseDialerTEISR.drawStringWithShadow(-0.32f, 0.32f - 0.32f * (float)offset, index + 1 + ".", active, false);
                            StargateAddress address = new StargateAddress(entryCompound);
                            int symbolCount = SymbolUniverseEnum.getMaxSymbolsDisplay(entryCompound.func_74767_n("hasUpgrade"));
                            EnumStargateState gateStatus = EnumStargateState.valueOf(compound.func_74762_e("gateStatus"));
                            boolean isIdle = gateStatus.idle();
                            StargateAddressDynamic dialedAddress = UniverseDialerTEISR.addrFromBytes(compound, "dialedAddress");
                            StargateAddressDynamic toDialAddress = UniverseDialerTEISR.addrFromBytes(compound, "toDialAddress");
                            int dialed = -1;
                            if (toDialAddress != null && toDialAddress.equals(address)) {
                                dialed = 0;
                            }
                            if (dialedAddress != null && dialed >= 0) {
                                dialed = dialedAddress.getSize();
                            }
                            if (dialed == 0 && isIdle) {
                                dialed = -1;
                            }
                            if (dialed == -1) {
                                engage_poo = false;
                            } else if (symbolCount == 8) {
                                engage_poo = dialed == 9;
                            } else {
                                boolean bl2 = engage_poo = dialed == 7;
                            }
                            if (entryCompound.func_74764_b("name")) {
                                String entryName = entryCompound.func_74779_i("name");
                                if (dialed > -1) {
                                    entryName = entryName + " (" + dialed + ")";
                                }
                                UniverseDialerTEISR.drawStringWithShadow(-0.05f, 0.32f - 0.32f * (float)offset, entryName, active, false, true, dialed > 0, gateStatus);
                                continue block5;
                            }
                            for (int i = 0; i < symbolCount; ++i) {
                                boolean engage_s = i < dialed;
                                UniverseDialerTEISR.renderSymbol(offset, i, address.get(i), active, symbolCount == 8, engage_s, gateStatus);
                            }
                            UniverseDialerTEISR.renderSymbol(offset, symbolCount, SymbolUniverseEnum.getOrigin(), active, symbolCount == 8, engage_poo, gateStatus);
                            continue block5;
                        }
                        case RINGS: {
                            TransportRings rings = new TransportRings(entryCompound);
                            UniverseDialerTEISR.drawStringWithShadow(-0.32f, 0.32f - 0.32f * (float)offset, rings.getAddress() + ".", active, false);
                            UniverseDialerTEISR.drawStringWithShadow(-0.1f, 0.32f - 0.32f * (float)offset, rings.getName(), active, false);
                            continue block5;
                        }
                        case OC: {
                            ItemOCMessage message = new ItemOCMessage(entryCompound);
                            UniverseDialerTEISR.drawStringWithShadow(-0.32f, 0.32f - 0.32f * (float)offset, index + 1 + ".", active, false);
                            UniverseDialerTEISR.drawStringWithShadow(-0.1f, 0.32f - 0.32f * (float)offset, message.name, active, false);
                        }
                    }
                }
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static StargateAddressDynamic addrFromBytes(NBTTagCompound compound, String baseName) {
        if (compound == null || baseName == null) {
            return null;
        }
        SymbolTypeEnum symbolType = SymbolTypeEnum.valueOf(compound.func_74771_c(baseName + "_symbolType"));
        StargateAddressDynamic newAddress = new StargateAddressDynamic(symbolType);
        int addressLength = compound.func_74771_c(baseName + "_addressLength");
        block5: for (int i = 0; i < addressLength; ++i) {
            byte symbolId = compound.func_74771_c(baseName + "_" + i);
            switch (symbolType) {
                case MILKYWAY: {
                    newAddress.addSymbol(SymbolMilkyWayEnum.valueOf(symbolId));
                    continue block5;
                }
                case PEGASUS: {
                    newAddress.addSymbol(SymbolPegasusEnum.valueOf(symbolId));
                    continue block5;
                }
                case UNIVERSE: {
                    newAddress.addSymbol(SymbolUniverseEnum.valueOf(symbolId));
                    continue block5;
                }
            }
        }
        return newAddress;
    }

    private static void drawStringWithShadow(float x, float y, String text, boolean active, boolean red) {
        UniverseDialerTEISR.drawStringWithShadow(x, y, text, active, red, false, false, EnumStargateState.IDLE);
    }

    private static void drawStringWithShadow(float x, float y, String text, boolean isActive, boolean redDef, boolean isAddress, boolean dialing, EnumStargateState stargateState) {
        boolean isEngaged = stargateState.engaged() || stargateState.initiating();
        boolean isEngagedInitiating = stargateState.initiating();
        boolean isIncoming = stargateState.incoming();
        boolean isFailing = stargateState.failing();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.015f, (float)0.015f, (float)0.015f);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (!isActive || isIncoming || !isEngagedInitiating && isEngaged) {
            alpha = 0.3f;
        }
        if (dialing) {
            red = 0.0f;
            green = 0.5f;
            blue = 1.0f;
        }
        if (isEngaged && dialing) {
            red = 0.0f;
            green = 1.0f;
            blue = 0.5f;
        }
        if (isFailing && dialing) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.3f;
        }
        if (isIncoming || !isEngagedInitiating && isEngaged) {
            red = 1.0f;
            green = 0.7f;
            blue = 0.0f;
        }
        int color = !isAddress ? (isActive ? 0xFFFFFF : 24831) : new Color(red, green, blue, alpha).getRGB();
        AunisFontRenderer.getFontRenderer().func_175065_a(text, -6.0f, 19.0f, color, false);
        if (isActive) {
            GlStateManager.func_179137_b((double)-0.4, (double)0.6, (double)-0.1);
            AunisFontRenderer.getFontRenderer().func_175065_a(text, -6.0f, 19.0f, color, false);
        }
        GlStateManager.func_179121_F();
    }

    private static void renderSymbol(int row, int col, SymbolInterface symbol, boolean isActive, boolean is9Chevron, boolean engage, EnumStargateState stargateState) {
        boolean isEngaged = stargateState.engaged() || stargateState.initiating();
        boolean isEngagedInitiating = stargateState.initiating();
        boolean isIncoming = stargateState.incoming();
        boolean isFailing = stargateState.failing();
        float x = (float)col * 0.09f - 0.05f;
        float y = (float)(-row) * 0.32f - 0.16f;
        float scale = 0.7f;
        float w = 0.19f * scale;
        float h = 0.4f * scale;
        if (!is9Chevron) {
            x += 0.09f;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(symbol.getIconResource());
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (!isActive || isIncoming || !isEngagedInitiating && isEngaged) {
            alpha = 0.3f;
        }
        if (!isEngaged && engage) {
            red = 0.0f;
            green = 0.5f;
            blue = 1.0f;
        }
        if (isEngaged && engage) {
            red = 0.0f;
            green = 1.0f;
            blue = 0.5f;
        }
        if (isFailing && engage) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.3f;
        }
        if (isIncoming || !isEngagedInitiating && isEngaged) {
            red = 1.0f;
            green = 0.7f;
            blue = 0.0f;
        }
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        UniverseDialerTEISR.drawTexturedRect(x, y, 0.0f, w, h);
        float shadow = 0.008f;
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.15f);
        UniverseDialerTEISR.drawTexturedRect(x + shadow, y - shadow, -0.01f, w, h);
    }

    private static void drawTexturedRect(float x, float y, float z, float w, float h) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(x + w), (float)y, (float)z);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(x + w), (float)(y + h), (float)z);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)(y + h), (float)z);
        GL11.glEnd();
    }

    private static void renderArms(EnumHandSide handSide, float angle, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)20.0f);
        ItemRenderHelper.applyBobbing(partialTicks);
        if (handSide == EnumHandSide.RIGHT) {
            GlStateManager.func_179137_b((double)-0.3, (double)-0.4, (double)0.0);
            GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-0.15 * (double)angle), (double)(-0.5 * (double)angle), (double)0.0);
            GlStateManager.func_179114_b((float)(10.0f * angle), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179137_b((double)0.3, (double)-0.4, (double)0.0);
            GlStateManager.func_179114_b((float)-25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(0.15 * (double)angle), (double)(-0.5 * (double)angle), (double)0.0);
            GlStateManager.func_179114_b((float)(-10.0f * angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        ItemRenderHelper.renderArmFirstPersonSide(0.0f, handSide, 0.0f, null);
        GlStateManager.func_179121_F();
    }
}

