/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item.dialer;

import mrjake.aunis.Aunis;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.util.EnumKeyInterface;
import mrjake.aunis.util.EnumKeyMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum UniverseDialerMode implements EnumKeyInterface<Byte>
{
    NEARBY(0, "item.aunis.universe_dialer.mode_scan", true, "linkedGate", "nearby", BlockMatcher.func_177642_a((Block)AunisBlocks.STARGATE_UNIVERSE_BASE_BLOCK)),
    MEMORY(1, "item.aunis.universe_dialer.mode_saved", true, "linkedGate", "saved", BlockMatcher.func_177642_a((Block)AunisBlocks.STARGATE_UNIVERSE_BASE_BLOCK)),
    RINGS(2, "item.aunis.universe_dialer.mode_rings", true, "linkedRings", "rings", BlockMatcher.func_177642_a((Block)AunisBlocks.TRANSPORT_RINGS_BLOCK)),
    OC(3, "item.aunis.universe_dialer.mode_oc", false, null, "ocmess", null);

    public final byte id;
    public final String translationKey;
    public final boolean linkable;
    public final String tagPosName;
    public final String tagListName;
    public final BlockMatcher matcher;
    private static final EnumKeyMap<Byte, UniverseDialerMode> ID_MAP;

    private UniverseDialerMode(int id, String translationKey, boolean linkable, String tagPosName, String tagListName, BlockMatcher matcher) {
        this.id = (byte)id;
        this.translationKey = translationKey;
        this.linkable = linkable;
        this.tagPosName = tagPosName;
        this.tagListName = tagListName;
        this.matcher = matcher;
    }

    public UniverseDialerMode next() {
        switch (this) {
            case NEARBY: {
                return MEMORY;
            }
            case MEMORY: {
                return RINGS;
            }
            case RINGS: {
                return Aunis.ocWrapper.isModLoaded() ? OC : NEARBY;
            }
            case OC: {
                return NEARBY;
            }
        }
        return null;
    }

    public UniverseDialerMode prev() {
        switch (this) {
            case NEARBY: {
                return Aunis.ocWrapper.isModLoaded() ? OC : RINGS;
            }
            case MEMORY: {
                return NEARBY;
            }
            case RINGS: {
                return MEMORY;
            }
            case OC: {
                return RINGS;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public String localize() {
        return I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]);
    }

    @Override
    public Byte getKey() {
        return this.id;
    }

    public static UniverseDialerMode valueOf(byte id) {
        return ID_MAP.valueOf(id);
    }

    static {
        ID_MAP = new EnumKeyMap((EnumKeyInterface[])UniverseDialerMode.values());
    }
}

