/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item.dialer;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import mrjake.aunis.Aunis;
import mrjake.aunis.capability.endpoint.ItemEndpointCapability;
import mrjake.aunis.capability.endpoint.ItemEndpointInterface;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.dialer.UniverseDialerCapabilityProvider;
import mrjake.aunis.item.dialer.UniverseDialerMode;
import mrjake.aunis.item.dialer.UniverseDialerTEISR;
import mrjake.aunis.item.oc.ItemOCMessage;
import mrjake.aunis.item.renderer.CustomModel;
import mrjake.aunis.item.renderer.CustomModelItemInterface;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.StargateClosedReasonEnum;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.StargateNetwork;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.stargate.network.SymbolUniverseEnum;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import mrjake.aunis.tileentity.stargate.StargateUniverseBaseTile;
import mrjake.aunis.tileentity.transportrings.TransportRingsAbstractTile;
import mrjake.aunis.transportrings.TransportRings;
import mrjake.aunis.util.EnumKeyInterface;
import mrjake.aunis.util.EnumKeyMap;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UniverseDialerItem
extends Item
implements CustomModelItemInterface {
    public static final String ITEM_NAME = "universe_dialer";
    private CustomModel customModel;

    public UniverseDialerItem() {
        this.setRegistryName(new ResourceLocation("aunis", ITEM_NAME));
        this.func_77655_b("aunis.universe_dialer");
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(Aunis.aunisItemsCreativeTab);
    }

    private static void checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            UniverseDialerItem.initNBT(stack);
        }
    }

    private static void initNBT(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        switch (UniverseDialerVariants.valueOf(stack.func_77952_i())) {
            case NORMAL: {
                compound.func_74774_a("mode", UniverseDialerMode.NEARBY.id);
                compound.func_74774_a("selected", (byte)0);
                compound.func_74782_a("saved", (NBTBase)new NBTTagList());
                break;
            }
        }
        stack.func_77982_d(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            UniverseDialerItem.initNBT(stack);
            items.add((Object)stack);
        }
    }

    @Override
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    public ItemCameraTransforms.TransformType getLastTransform() {
        return this.customModel.lastTransform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntityItemStackRenderer createTEISR() {
        return new UniverseDialerTEISR();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (stack.func_77952_i() == UniverseDialerVariants.BROKEN.meta) {
            return null;
        }
        return new UniverseDialerCapabilityProvider();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == UniverseDialerVariants.BROKEN.meta) {
            return "item.aunis.universe_dialer.broken";
        }
        return super.func_77667_c(stack);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            switch (UniverseDialerVariants.valueOf(stack.func_77952_i())) {
                case NORMAL: {
                    NBTTagList list = stack.func_77978_p().func_150295_c("saved", 10);
                    tooltip.add(TextFormatting.GRAY + Aunis.proxy.localize("item.aunis.universe_dialer.saved_gates", list.func_74745_c()));
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound compound = list.func_150305_b(i);
                        if (!compound.func_74764_b("name")) continue;
                        tooltip.add(TextFormatting.AQUA + compound.func_74779_i("name"));
                    }
                    break;
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            UniverseDialerItem.checkNBT(stack);
            if (stack.func_77952_i() == UniverseDialerVariants.BROKEN.meta) {
                return;
            }
            NBTTagCompound compound = stack.func_77978_p();
            if (world.func_82737_E() % 20L == 0L && isSelected) {
                BlockPos pos = entity.func_180425_c();
                int reachSquared = AunisConfig.stargateConfig.universeDialerReach * AunisConfig.stargateConfig.universeDialerReach * 2;
                UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
                if (mode.linkable) {
                    BlockPos tilePos;
                    if (compound.func_74764_b(mode.tagPosName) && (!mode.matcher.apply(world.func_180495_p(tilePos = BlockPos.func_177969_a((long)compound.func_74763_f(mode.tagPosName)))) || tilePos.func_177951_i((Vec3i)pos) > (double)reachSquared)) {
                        compound.func_82580_o(mode.tagPosName);
                    }
                    boolean found = false;
                    block6: for (BlockPos targetPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-10, -10, -10), (BlockPos)pos.func_177982_a(10, 10, 10))) {
                        long targetPosOld;
                        if (mode.matcher.apply(world.func_180495_p(targetPos))) {
                            switch (mode) {
                                case MEMORY: 
                                case NEARBY: {
                                    StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(targetPos);
                                    if (!gateTile.isMerged()) continue block6;
                                    NBTTagList nearbyList = new NBTTagList();
                                    int squaredGate = AunisConfig.stargateConfig.universeGateNearbyReach * AunisConfig.stargateConfig.universeGateNearbyReach;
                                    compound.func_74757_a("requireOnlySeven", true);
                                    try {
                                        UniverseDialerItem.addrToBytes(gateTile.getDialedAddress(), compound, "dialedAddress");
                                        UniverseDialerItem.addrToBytes(((StargateUniverseBaseTile)gateTile).addressToDial, compound, "toDialAddress");
                                        compound.func_74768_a("gateStatus", gateTile.getStargateState().id);
                                        for (Map.Entry<StargateAddress, StargatePos> entry : StargateNetwork.get(world).getMap().get(SymbolTypeEnum.UNIVERSE).entrySet()) {
                                            StargateAbstractBaseTile targetGateTile;
                                            StargatePos stargatePos = entry.getValue();
                                            if (stargatePos.dimensionID != world.field_73011_w.getDimension() || stargatePos.gatePos.func_177951_i((Vec3i)targetPos) > (double)squaredGate || stargatePos.gatePos.equals((Object)targetPos) || !((targetGateTile = stargatePos.getTileEntity()) instanceof StargateClassicBaseTile) || !targetGateTile.isMerged() || !(targetGateTile instanceof StargateUniverseBaseTile) && mode.equals(UniverseDialerMode.NEARBY)) continue;
                                            NBTTagCompound entryCompound = entry.getKey().serializeNBT();
                                            entryCompound.func_74757_a("requireOnlySeven", true);
                                            nearbyList.func_74742_a((NBTBase)entryCompound);
                                        }
                                        compound.func_74782_a(UniverseDialerMode.NEARBY.tagListName, (NBTBase)nearbyList);
                                        compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                                        found = true;
                                    }
                                    catch (ConcurrentModificationException e) {
                                        Aunis.logger.error("Error while iterating nearby stargates occurred", (Throwable)e);
                                        if (entity instanceof EntityPlayer) {
                                            ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("item.aunis.universe_dialer.dialer_broke", new Object[0]), true);
                                        }
                                        UniverseDialerItem.broke(stack);
                                    }
                                    break;
                                }
                                case RINGS: {
                                    TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(targetPos);
                                    NBTTagList ringsList = new NBTTagList();
                                    for (TransportRings rings : ringsTile.ringsMap.values()) {
                                        ringsList.func_74742_a((NBTBase)rings.serializeNBT());
                                    }
                                    compound.func_74782_a(mode.tagListName, (NBTBase)ringsList);
                                    compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                                    found = true;
                                    break;
                                }
                            }
                        }
                        if (!found) continue;
                        if (!compound.func_74764_b(mode.tagPosName) || (targetPosOld = compound.func_74763_f(mode.tagPosName)) == targetPos.func_177986_g() || !(entity instanceof EntityPlayer)) break;
                        AunisSoundHelper.playSoundEventClientSide(entity.func_130014_f_(), entity.func_180425_c(), SoundEventEnum.UNIVERSE_DIALER_CONNECTED);
                        break;
                    }
                }
            }
            ItemEndpointInterface endpointStack = (ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null);
            endpointStack.checkAndUpdateEndpoint(world.func_82737_E());
        }
    }

    private static void addrToBytes(StargateAddress address, NBTTagCompound compound, String baseName) {
        if (compound == null || address == null || baseName == null) {
            return;
        }
        compound.func_74774_a(baseName + "_addressLength", (byte)address.getSize());
        compound.func_74774_a(baseName + "_symbolType", (byte)address.getSymbolType().id);
        for (int i = 0; i < address.getSize(); ++i) {
            compound.func_74774_a(baseName + "_" + i, (byte)address.get(i).getId());
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (stack.func_77952_i() != UniverseDialerVariants.BROKEN.meta) {
            ((ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null)).removeEndpoint();
        }
        return super.onDroppedByPlayer(stack, player);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_184586_b(hand).func_77952_i() == UniverseDialerVariants.NORMAL.meta) {
            UniverseDialerItem.checkNBT(player.func_184586_b(hand));
            NBTTagCompound compound = player.func_184586_b(hand).func_77978_p();
            UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
            byte selected = compound.func_74771_c("selected");
            if (mode.linkable && !compound.func_74764_b(mode.tagPosName)) {
                return super.func_77659_a(world, player, hand);
            }
            BlockPos linkedPos = BlockPos.func_177969_a((long)compound.func_74763_f(mode.tagPosName));
            NBTTagList tagList = compound.func_150295_c(mode.tagListName, 10);
            if (selected >= tagList.func_74745_c()) {
                return super.func_77659_a(world, player, hand);
            }
            NBTTagCompound selectedCompound = tagList.func_150305_b((int)selected);
            block0 : switch (mode) {
                case MEMORY: 
                case NEARBY: {
                    StargateUniverseBaseTile gateTile = (StargateUniverseBaseTile)world.func_175625_s(linkedPos);
                    switch (gateTile.getStargateState()) {
                        case IDLE: {
                            int maxSymbols = SymbolUniverseEnum.getMaxSymbolsDisplay(selectedCompound.func_74767_n("hasUpgrade"));
                            gateTile.dial(new StargateAddress(selectedCompound), maxSymbols, mode == UniverseDialerMode.NEARBY);
                            AunisSoundHelper.playSoundEventClientSide(world, player.func_180425_c(), SoundEventEnum.UNIVERSE_DIALER_START_DIAL);
                            break block0;
                        }
                        case ENGAGED_INITIATING: {
                            gateTile.attemptClose(StargateClosedReasonEnum.REQUESTED);
                            break block0;
                        }
                        case ENGAGED: {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.dhd_block.incoming_wormhole_warn", new Object[0]), true);
                            break block0;
                        }
                    }
                    if (gateTile.getStargateState() == EnumStargateState.DIALING) {
                        gateTile.abort();
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.aunis.universe_dialer.aborting", new Object[0]), true);
                        break;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.aunis.universe_dialer.gate_busy", new Object[0]), true);
                    break;
                }
                case RINGS: {
                    TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(linkedPos);
                    ringsTile.attemptTransportTo(new TransportRings(selectedCompound).getAddress(), 0).sendMessageIfFailed(player);
                    break;
                }
                case OC: {
                    ItemOCMessage message = new ItemOCMessage(selectedCompound);
                    Aunis.logger.debug("Sending OC message: " + message.toString());
                    Aunis.ocWrapper.sendWirelessPacketPlayer(player, player.func_184586_b(hand), message.address, message.port, message.getData());
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public void setCustomModelLocation() {
        ModelResourceLocation modelLocation = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)modelLocation);
        CustomModelItemInterface.super.setCustomModelLocation();
        ModelBakery.registerItemVariants((Item)AunisItems.UNIVERSE_DIALER, (ResourceLocation[])new ResourceLocation[]{modelLocation});
        ModelLoader.setCustomMeshDefinition((Item)AunisItems.UNIVERSE_DIALER, stack -> modelLocation);
    }

    public static void broke(ItemStack stack) {
        if (stack.func_77973_b() == AunisItems.UNIVERSE_DIALER) {
            stack.func_77964_b(UniverseDialerVariants.BROKEN.meta);
            if (stack.func_77942_o()) {
                stack.func_77982_d(null);
            }
        }
    }

    public static void setMemoryNameForIndex(NBTTagList list, int index, String name) {
        list.func_150305_b(index).func_74778_a("name", name);
    }

    public static void changeOCMessageAtIndex(NBTTagList list, int index, ChangeMessage changeMessage) {
        ItemOCMessage message = new ItemOCMessage(list.func_150305_b(index));
        changeMessage.change(message);
        list.func_150304_a(index, (NBTBase)message.serializeNBT());
    }

    public static interface ChangeMessage {
        public void change(ItemOCMessage var1);
    }

    public static enum UniverseDialerVariants implements EnumKeyInterface<Integer>
    {
        NORMAL(0, "universe_dialer"),
        BROKEN(1, "universe_dialer_broken");

        public final int meta;
        public final String name;
        private static final EnumKeyMap<Integer, UniverseDialerVariants> KEY_MAP;

        private UniverseDialerVariants(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        @Override
        public Integer getKey() {
            return this.meta;
        }

        public static UniverseDialerVariants valueOf(int id) {
            return KEY_MAP.valueOf(id);
        }

        static {
            KEY_MAP = new EnumKeyMap((EnumKeyInterface[])UniverseDialerVariants.values());
        }
    }
}

