/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.item;

import java.util.List;
import javax.annotation.Nullable;
import mrjake.aunis.capability.CapacitorCapabilityProvider;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.stargate.power.StargateItemEnergyStorage;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ZPMItemBlock
extends ItemBlock {
    public ZPMItemBlock(Block block) {
        super(block);
        this.setRegistryName("zpm");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            StargateItemEnergyStorage energyStorage = (StargateItemEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            energyStorage.setEnergyStored(AunisConfig.powerConfig.zpmEnergyStorage);
            items.add((Object)stack);
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        String energy = String.format("%,d", energyStorage.getEnergyStored());
        String capacity = String.format("%,d", AunisConfig.powerConfig.zpmEnergyStorage);
        tooltip.add(energy + " / " + capacity + " RF");
        String energyPercent = String.format("%.2f", Float.valueOf((float)energyStorage.getEnergyStored() / (float)AunisConfig.powerConfig.zpmEnergyStorage * 100.0f)) + " %";
        tooltip.add(energyPercent);
        String alert = "Work in progress item!";
        tooltip.add(alert);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CapacitorCapabilityProvider(stack, nbt);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return 1.0 - (double)energyStorage.getEnergyStored() / (double)AunisConfig.powerConfig.zpmEnergyStorage;
    }
}

