/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.notebook.PageNotebookItem;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class JEINotebookRecipe
implements IRecipeWrapper {
    static final ItemStack PAGE1 = JEINotebookRecipe.getRandomPageWithNameColor("Plains", "plains");
    static final ItemStack PAGE2 = JEINotebookRecipe.getRandomPageWithNameColor("Tundra", "ice");
    static final ItemStack NOTEBOOK = JEINotebookRecipe.getNotebookWithPages(1, PAGE1, PAGE2);
    static final ItemStack NOTEBOOK2 = JEINotebookRecipe.getNotebookWithPages(2, PAGE1, PAGE2);
    private List<ItemStack> inputs = new ArrayList<ItemStack>();
    private List<ItemStack> outputs = new ArrayList<ItemStack>();

    static ItemStack getRandomPageWithNameColor(String name, String biome) {
        ItemStack pageStack = new ItemStack((Item)AunisItems.PAGE_NOTEBOOK_ITEM, 1, 1);
        NBTTagCompound compound = new NBTTagCompound();
        pageStack.func_77982_d(compound);
        compound.func_74768_a("color", PageNotebookItem.getColorForBiome(biome));
        PageNotebookItem.setName(compound, name);
        StargateAddress address = new StargateAddress(SymbolTypeEnum.MILKYWAY).generate(new Random());
        compound.func_74768_a("symbolType", address.getSymbolType().id);
        compound.func_74782_a("address", (NBTBase)address.serializeNBT());
        compound.func_74757_a("hasUpgrade", false);
        return pageStack;
    }

    static ItemStack getNotebookWithPages(int quantity, ItemStack ... pages) {
        ItemStack notebook = new ItemStack((Item)AunisItems.NOTEBOOK_ITEM, quantity);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        compound.func_74782_a("addressList", (NBTBase)list);
        notebook.func_77982_d(compound);
        for (ItemStack stack : pages) {
            list.func_74742_a((NBTBase)stack.func_77978_p());
        }
        return notebook;
    }

    JEINotebookRecipe(NotebookRecipeVariantEnum variant) {
        switch (variant) {
            case TWO_PAGES: {
                this.inputs.add(PAGE1);
                this.inputs.add(PAGE2);
                this.outputs.add(NOTEBOOK);
                break;
            }
            case NOTEBOOK_PAGE: {
                this.inputs.add(PAGE1);
                this.inputs.add(JEINotebookRecipe.getNotebookWithPages(1, PAGE2));
                this.outputs.add(NOTEBOOK);
                break;
            }
            case NOTEBOOK_BOOK: {
                this.inputs.add(NOTEBOOK);
                this.inputs.add(new ItemStack(Items.field_151122_aG));
                this.outputs.add(NOTEBOOK2);
                break;
            }
            case TWO_NOTEBOOKS: {
                this.inputs.add(JEINotebookRecipe.getNotebookWithPages(1, PAGE1));
                this.inputs.add(JEINotebookRecipe.getNotebookWithPages(1, PAGE2));
                this.outputs.add(NOTEBOOK2);
            }
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
    }

    public static List<JEINotebookRecipe> genAll() {
        ArrayList<JEINotebookRecipe> list = new ArrayList<JEINotebookRecipe>();
        for (NotebookRecipeVariantEnum variant : NotebookRecipeVariantEnum.values()) {
            list.add(new JEINotebookRecipe(variant));
        }
        return list;
    }

    static enum NotebookRecipeVariantEnum {
        TWO_PAGES,
        NOTEBOOK_PAGE,
        NOTEBOOK_BOOK,
        TWO_NOTEBOOKS;

    }
}

