/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.mainmenu.screens.worldselection;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mrjake.aunis.gui.mainmenu.screens.AunisSinglePlayerGui;
import mrjake.aunis.gui.mainmenu.screens.worldselection.AunisGuiListWorldSelectionEntry;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AunisGuiListWorldSelection
extends GuiListExtended {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AunisSinglePlayerGui worldSelection;
    private final List<AunisGuiListWorldSelectionEntry> entries = Lists.newArrayList();
    private int selectedIdx = -1;

    public AunisGuiListWorldSelection(AunisSinglePlayerGui p_i46590_1_, Minecraft clientIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(clientIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.worldSelection = p_i46590_1_;
        this.refreshList();
    }

    public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.field_178041_q) {
            this.field_148150_g = mouseXIn;
            this.field_148162_h = mouseYIn;
            int i = this.func_148137_d();
            int j = i + 6;
            this.func_148121_k();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            int k = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int l = this.field_148153_b + 4 - (int)this.field_148169_q;
            if (this.field_148165_u) {
                this.func_148129_a(k, l, tessellator);
            }
            this.func_192638_a(k, l, mouseXIn, mouseYIn, partialTicks);
            GlStateManager.func_179097_i();
            this.func_148136_c(0, this.field_148153_b, 255, 255);
            this.func_148136_c(this.field_148154_c, this.field_148158_l, 255, 255);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            int j1 = this.func_148135_f();
            if (j1 > 0) {
                int k1 = (this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b) / this.func_148138_e();
                int l1 = (int)this.field_148169_q * (this.field_148154_c - this.field_148153_b - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8)))) / j1 + this.field_148153_b;
                if (l1 < this.field_148153_b) {
                    l1 = this.field_148153_b;
                }
            }
            this.func_148142_b(mouseXIn, mouseYIn);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
    }

    public void refreshList() {
        List list;
        ISaveFormat isaveformat = this.field_148161_k.func_71359_d();
        try {
            list = isaveformat.func_75799_b();
        }
        catch (AnvilConverterException anvilconverterexception) {
            LOGGER.error("Couldn't load level list", (Throwable)anvilconverterexception);
            this.field_148161_k.func_147108_a((GuiScreen)new GuiErrorScreen(I18n.func_135052_a((String)"selectWorld.unable_to_load", (Object[])new Object[0]), anvilconverterexception.getMessage()));
            return;
        }
        Collections.sort(list);
        for (WorldSummary worldsummary : list) {
            this.entries.add(new AunisGuiListWorldSelectionEntry(this, worldsummary, this.field_148161_k.func_71359_d()));
        }
    }

    public AunisGuiListWorldSelectionEntry getListEntry(int index) {
        return this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 20;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 50;
    }

    public void selectWorld(int idx) {
        this.selectedIdx = idx;
        this.worldSelection.selectWorld(this.getSelectedWorld());
    }

    protected boolean func_148131_a(int slotIndex) {
        return slotIndex == this.selectedIdx;
    }

    @Nullable
    public AunisGuiListWorldSelectionEntry getSelectedWorld() {
        return this.selectedIdx >= 0 && this.selectedIdx < this.func_148127_b() ? this.getListEntry(this.selectedIdx) : null;
    }

    public AunisSinglePlayerGui getGuiWorldSelection() {
        return this.worldSelection;
    }

    protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        this.getListEntry(slotIndex).func_192634_a(slotIndex, xPos, yPos, this.func_148139_c(), heightIn, mouseXIn, mouseYIn, this.func_148141_e(mouseYIn) && this.func_148124_c(mouseXIn, mouseYIn) == slotIndex, partialTicks);
    }

    protected void func_192639_a(int entryID, int insideLeft, int yPos, float partialTicks) {
        this.getListEntry(entryID).func_192633_a(entryID, insideLeft, yPos, partialTicks);
    }

    public boolean func_148179_a(int mouseX, int mouseY, int mouseEvent) {
        int i;
        if (this.func_148141_e(mouseY) && (i = this.func_148124_c(mouseX, mouseY)) >= 0) {
            int j = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int k = this.field_148153_b + 4 - this.func_148148_g() + i * this.field_148149_f + this.field_148160_j;
            int l = mouseX - j;
            int i1 = mouseY - k;
            if (this.getListEntry(i).func_148278_a(i, mouseX, mouseY, mouseEvent, l, i1)) {
                this.func_148143_b(false);
                return true;
            }
        }
        return false;
    }

    public boolean func_148181_b(int x, int y, int mouseEvent) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            int j = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int k = this.field_148153_b + 4 - this.func_148148_g() + i * this.field_148149_f + this.field_148160_j;
            int l = x - j;
            int i1 = y - k;
            this.getListEntry(i).func_148277_b(i, x, y, mouseEvent, l, i1);
        }
        this.func_148143_b(true);
        return false;
    }
}

