/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.mainmenu.screens.options;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.base.AunisGuiButton;
import mrjake.aunis.gui.base.AunisGuiSlider;
import mrjake.aunis.gui.mainmenu.screens.options.resourcepacks.AunisGuiResourcePackSelected;
import mrjake.aunis.gui.mainmenu.screens.options.resourcepacks.AunisGuiResourcePacksAvailable;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.sound.AunisSoundHelperClient;
import mrjake.aunis.sound.SoundPositionedEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackListEntry;
import net.minecraft.client.resources.ResourcePackListEntryDefault;
import net.minecraft.client.resources.ResourcePackListEntryFound;
import net.minecraft.client.resources.ResourcePackListEntryServer;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class AunisResourcePacksOptions
extends GuiScreenResourcePacks {
    protected static float animationStage = 0.0f;
    protected final float ringAnimationStepSetting = 0.3f;
    protected float ringAnimationStep = 0.0f;
    protected float ringAnimationSpeed = 1.0f;
    protected final boolean speedUpGate = true;
    protected final GuiScreen field_146965_f;
    protected static List<ResourcePackListEntry> availableResourcePacks;
    protected static List<ResourcePackListEntry> selectedResourcePacks;
    protected static AunisGuiResourcePacksAvailable availableResourcePacksList;
    protected static AunisGuiResourcePackSelected selectedResourcePacksList;
    protected boolean field_175289_s;
    protected int field_146287_f;
    protected int field_146298_h;
    protected long field_146288_g;
    protected BiomeOverlayEnum overlay;
    protected float screenCenterHeight = (float)this.field_146295_m / 2.0f;
    protected float screenCenterWidth = (float)this.field_146294_l / 2.0f;
    protected List<GuiButton> aunisButtonList = new ArrayList<GuiButton>();
    protected List<GuiButton> aunisButtonSliders = new ArrayList<GuiButton>();
    protected static final ResourceLocation BACKGROUND_TEXTURE;
    protected float kawooshState = 0.0f;
    protected float gateZoom = 0.0f;
    protected float gatePos = 0.0f;
    protected boolean isUnloading = false;

    public AunisResourcePacksOptions(GuiScreen parentScreenIn, BiomeOverlayEnum overlay) {
        super(parentScreenIn);
        this.field_146965_f = parentScreenIn;
        this.overlay = overlay;
    }

    @SubscribeEvent
    public static void onSounds(PlaySoundEvent event) {
        event.setResultSound(null);
    }

    public void updateRingSpeed() {
        if (!AunisConfig.mainMenuConfig.gateRotation) {
            return;
        }
        if (this.ringAnimationSpeed < 1.0f) {
            this.ringAnimationSpeed += 0.05f;
        }
        this.ringAnimationStep = 0.3f * this.ringAnimationSpeed;
        animationStage += this.ringAnimationStep;
    }

    public void updateSound() {
        AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(1, 0, 0), SoundPositionedEnum.MAINMENU_MUSIC, AunisConfig.mainMenuConfig.playMusic);
        AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 0, 1), SoundPositionedEnum.MAINMENU_RING_ROLL, AunisConfig.mainMenuConfig.gateRotation && this.kawooshState == 0.0f && this.ringAnimationSpeed > 0.0f);
    }

    public void updateAnimation() {
        this.screenCenterHeight = (float)this.field_146295_m / 2.0f;
        this.screenCenterWidth = (float)this.field_146294_l / 2.0f;
        if (this.gateZoom == 0.0f) {
            this.gateZoom = (float)this.field_146294_l / 6.0f;
        }
        if (this.gatePos == 0.0f) {
            this.gatePos = (float)this.field_146294_l - 54.0f;
        }
        float step = 8.0f;
        if (!this.isUnloading) {
            if (this.gatePos < 54.0f) {
                this.gatePos += step * 4.0f;
            }
            if (this.gatePos > 57.0f) {
                this.gatePos -= step * 4.0f;
            }
        } else {
            if (this.gatePos < (float)this.field_146294_l - 54.0f) {
                this.gatePos += step * 4.0f;
            }
            if (this.gatePos + (step * 4.0f + 25.0f) >= (float)this.field_146294_l - 54.0f) {
                this.field_146297_k.func_147108_a(this.field_146965_f);
            }
        }
        if (animationStage > 360.0f) {
            animationStage = 0.0f;
        }
        this.updateRingSpeed();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.updateAnimation();
        this.updateSound();
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        AunisResourcePacksOptions.func_152125_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (int)this.field_146294_l, (int)this.field_146295_m, (float)this.field_146294_l, (float)this.field_146295_m);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179090_x();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179109_b((float)this.gatePos, (float)this.screenCenterHeight, (float)0.0f);
        GlStateManager.func_179152_a((float)this.gateZoom, (float)this.gateZoom, (float)this.gateZoom);
        GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        ElementEnum.MILKYWAY_GATE_MAINMENU.bindTextureAndRender(this.overlay);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179114_b((float)animationStage, (float)0.0f, (float)0.0f, (float)1.0f);
        ElementEnum.MILKYWAY_RING_MAINMENU.bindTextureAndRender(this.overlay);
        GlStateManager.func_179121_F();
        for (int i = 0; i < 9; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.03f);
            GlStateManager.func_179114_b((float)ChevronEnum.valueOf((int)i).rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            ElementEnum.MILKYWAY_CHEVRON_FRAME_MAINMENU.bindTextureAndRender(this.overlay);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_LIGHT_MAINMENU.bindTextureAndRender(this.overlay);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_MOVING_MAINMENU.bindTextureAndRender(this.overlay);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179121_F();
        if (!this.isUnloading) {
            availableResourcePacksList.func_148128_a(mouseX, mouseY, partialTicks);
            selectedResourcePacksList.func_148128_a(mouseX, mouseY, partialTicks);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"resourcePack.title", (Object[])new Object[0]), this.field_146294_l / 2, 16, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"resourcePack.folderInfo", (Object[])new Object[0]), this.field_146294_l / 2 - 102, this.field_146295_m - 48, 0x808080);
            GlStateManager.func_179094_E();
            for (GuiButton guiButton : this.aunisButtonList) {
                ((AunisGuiButton)guiButton).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            }
            for (GuiButton guiButton : this.aunisButtonSliders) {
                ((AunisGuiSlider)guiButton).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            }
            for (GuiLabel guiLabel : this.field_146293_o) {
                guiLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected void frame(int x, int y, int w, int h, int thickness, int borderColor, int background) {
        AunisResourcePacksOptions.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + thickness), (int)borderColor);
        AunisResourcePacksOptions.func_73734_a((int)x, (int)(y + h - thickness), (int)(x + w), (int)(y + h), (int)borderColor);
        AunisResourcePacksOptions.func_73734_a((int)x, (int)(y + thickness), (int)(x + thickness), (int)(y + h - thickness), (int)borderColor);
        AunisResourcePacksOptions.func_73734_a((int)(x + w - thickness), (int)(y + thickness), (int)(x + w), (int)(y + h - thickness), (int)borderColor);
        AunisResourcePacksOptions.func_73734_a((int)(x + thickness), (int)(y + thickness), (int)(x + w - thickness), (int)(y + h - thickness), (int)background);
    }

    public void func_73866_w_() {
        this.screenCenterHeight = (float)this.field_146295_m / 2.0f;
        this.screenCenterWidth = (float)this.field_146294_l / 2.0f;
        this.aunisButtonList.clear();
        this.aunisButtonList.add(new AunisGuiButton(2, this.field_146294_l / 2 - 205, this.field_146295_m - 38, I18n.func_135052_a((String)"resourcePack.openFolder", (Object[])new Object[0])));
        this.aunisButtonList.add(new AunisGuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        if (!this.field_175289_s) {
            availableResourcePacks = Lists.newArrayList();
            selectedResourcePacks = Lists.newArrayList();
            ResourcePackRepository resourcepackrepository = this.field_146297_k.func_110438_M();
            resourcepackrepository.func_110611_a();
            ArrayList list = Lists.newArrayList((Iterable)resourcepackrepository.func_110609_b());
            list.removeAll(resourcepackrepository.func_110613_c());
            for (ResourcePackRepository.Entry resourcepackrepository$entry : list) {
                availableResourcePacks.add((ResourcePackListEntry)new ResourcePackListEntryFound((GuiScreenResourcePacks)this, resourcepackrepository$entry));
            }
            ResourcePackRepository.Entry resourcepackrepository$entry2 = resourcepackrepository.func_188565_b();
            if (resourcepackrepository$entry2 != null) {
                selectedResourcePacks.add((ResourcePackListEntry)new ResourcePackListEntryServer((GuiScreenResourcePacks)this, resourcepackrepository.func_148530_e()));
            }
            for (ResourcePackRepository.Entry resourcepackrepository$entry1 : Lists.reverse((List)resourcepackrepository.func_110613_c())) {
                selectedResourcePacks.add((ResourcePackListEntry)new ResourcePackListEntryFound((GuiScreenResourcePacks)this, resourcepackrepository$entry1));
            }
            selectedResourcePacks.add((ResourcePackListEntry)new ResourcePackListEntryDefault((GuiScreenResourcePacks)this));
        }
        availableResourcePacksList = new AunisGuiResourcePacksAvailable(this.field_146297_k, 200, this.field_146295_m, availableResourcePacks);
        availableResourcePacksList.func_148140_g(this.field_146294_l / 2 - 4 - 200);
        availableResourcePacksList.func_148134_d(7, 8);
        selectedResourcePacksList = new AunisGuiResourcePackSelected(this.field_146297_k, 200, this.field_146295_m, selectedResourcePacks);
        selectedResourcePacksList.func_148140_g(this.field_146294_l / 2 + 4);
        selectedResourcePacksList.func_148134_d(7, 8);
        super.func_73866_w_();
    }

    public void func_146274_d() throws IOException {
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int k = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            if (this.field_146297_k.field_71474_y.field_85185_A && this.field_146298_h++ > 0) {
                return;
            }
            this.field_146287_f = k;
            this.field_146288_g = Minecraft.func_71386_F();
            this.func_73864_a(i, j, this.field_146287_f);
        } else if (k != -1) {
            if (this.field_146297_k.field_71474_y.field_85185_A && --this.field_146298_h > 0) {
                return;
            }
            this.field_146287_f = -1;
            this.func_146286_b(i, j, k);
        } else if (this.field_146287_f != -1 && this.field_146288_g > 0L) {
            long l = Minecraft.func_71386_F() - this.field_146288_g;
            this.func_146273_a(i, j, this.field_146287_f, l);
        }
        selectedResourcePacksList.func_178039_p();
        availableResourcePacksList.func_178039_p();
    }

    public boolean func_146961_a(ResourcePackListEntry resourcePackEntry) {
        return selectedResourcePacks.contains(resourcePackEntry);
    }

    public List<ResourcePackListEntry> func_146962_b(ResourcePackListEntry resourcePackEntry) {
        return this.func_146961_a(resourcePackEntry) ? selectedResourcePacks : availableResourcePacks;
    }

    public List<ResourcePackListEntry> func_146964_g() {
        return availableResourcePacks;
    }

    public List<ResourcePackListEntry> func_146963_h() {
        return selectedResourcePacks;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 2) {
                File file1 = this.field_146297_k.func_110438_M().func_110612_e();
                OpenGlHelper.func_188786_a((File)file1);
            } else if (button.field_146127_k == 1) {
                if (this.field_175289_s) {
                    ArrayList list = Lists.newArrayList();
                    for (ResourcePackListEntry resourcepacklistentry : selectedResourcePacks) {
                        if (!(resourcepacklistentry instanceof ResourcePackListEntryFound)) continue;
                        list.add(((ResourcePackListEntryFound)resourcepacklistentry).func_148318_i());
                    }
                    Collections.reverse(list);
                    this.field_146297_k.func_110438_M().func_148527_a((List)list);
                    this.field_146297_k.field_71474_y.field_151453_l.clear();
                    this.field_146297_k.field_71474_y.field_183018_l.clear();
                    for (ResourcePackRepository.Entry resourcepackrepository$entry : list) {
                        this.field_146297_k.field_71474_y.field_151453_l.add(resourcepackrepository$entry.func_110515_d());
                        if (resourcepackrepository$entry.func_183027_f() == 3) continue;
                        this.field_146297_k.field_71474_y.field_183018_l.add(resourcepackrepository$entry.func_110515_d());
                    }
                    this.field_146297_k.field_71474_y.func_74303_b();
                    this.field_146297_k.func_110436_a();
                }
                this.isUnloading = true;
            }
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (GuiButton guibutton : this.aunisButtonList) {
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.aunisButtonList);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.field_146290_a = guibutton = event.getButton();
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.aunisButtonList));
            }
        }
        availableResourcePacksList.mouseClicked(mouseX, mouseY, mouseButton);
        selectedResourcePacksList.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_175288_g() {
        this.field_175289_s = true;
    }

    static {
        BACKGROUND_TEXTURE = AunisConfig.mainMenuConfig.disableAunisMainMenu ? null : new ResourceLocation("aunis", "textures/gui/mainmenu/background.jpg");
    }
}

