/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.mainmenu.screens.modlist;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class AunisGuiScrollingList
extends GuiScrollingList {
    public final Minecraft client;
    public final int listWidth;
    public final int listHeight;
    public final int screenWidth;
    public final int screenHeight;
    public final int top;
    public final int bottom;
    public final int right;
    public final int left;
    public final int slotHeight;
    public int scrollUpActionId;
    public int scrollDownActionId;
    public int mouseX;
    public int mouseY;
    public float initialMouseClickY = -2.0f;
    public float scrollFactor;
    public float scrollDistance;
    public int selectedIndex = -1;
    public long lastClickTime = 0L;
    public boolean highlightSelected = true;
    public boolean hasHeader;
    public int headerHeight;

    @Deprecated
    public AunisGuiScrollingList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight) {
        this(client, width, height, top, bottom, left, entryHeight, width, height);
    }

    public AunisGuiScrollingList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
        super(client, width, height, top, bottom, left, entryHeight, screenWidth, screenHeight);
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + this.left;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Deprecated
    public void func_27258_a(boolean p_27258_1_) {
        this.highlightSelected = p_27258_1_;
    }

    @Deprecated
    protected void func_27259_a(boolean hasFooter, int footerHeight) {
        this.setHeaderInfo(hasFooter, footerHeight);
    }

    protected void setHeaderInfo(boolean hasHeader, int headerHeight) {
        this.hasHeader = hasHeader;
        this.headerHeight = headerHeight;
        if (!hasHeader) {
            this.headerHeight = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerHeight;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    @Deprecated
    protected void func_27260_a(int entryRight, int relativeY, Tessellator tess) {
    }

    protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
        this.func_27260_a(entryRight, relativeY, tess);
    }

    @Deprecated
    protected void func_27255_a(int x, int y) {
    }

    protected void clickHeader(int x, int y) {
        this.func_27255_a(x, y);
    }

    @Deprecated
    protected void func_27257_b(int mouseX, int mouseY) {
    }

    public void drawScreen(int mouseX, int mouseY) {
        this.func_27257_b(mouseX, mouseY);
    }

    @Deprecated
    public int func_27256_c(int x, int y) {
        int left = this.left + 1;
        int right = this.left + this.listWidth - 7;
        int relativeY = y - this.top - this.headerHeight + (int)this.scrollDistance - 4;
        int entryIndex = relativeY / this.slotHeight;
        return x >= left && x <= right && entryIndex >= 0 && relativeY >= 0 && entryIndex < this.getSize() ? entryIndex : -1;
    }

    public void registerScrollButtons(List<GuiButton> buttons, int upActionID, int downActionID) {
        this.scrollUpActionId = upActionID;
        this.scrollDownActionId = downActionID;
    }

    private void applyScrollLimits() {
        int listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
        if (listHeight < 0) {
            listHeight /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)listHeight) {
            this.scrollDistance = listHeight;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.scrollUpActionId) {
                this.scrollDistance -= (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.field_146127_k == this.scrollDownActionId) {
                this.scrollDistance += (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    public void handleMouseInput(int mouseX, int mouseY) throws IOException {
        boolean isHovering;
        boolean bl = isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        if (!isHovering) {
            return;
        }
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            this.scrollDistance += (float)(-1 * scroll) / 120.0f * (float)this.slotHeight / 2.0f;
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        boolean isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        int listLength = this.getSize();
        int scrollBarWidth = 6;
        int scrollBarRight = this.left + this.listWidth;
        int scrollBarLeft = scrollBarRight - scrollBarWidth;
        int entryLeft = this.left;
        int entryRight = scrollBarLeft - 1;
        int viewHeight = this.bottom - this.top;
        int border = 4;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                if (isHovering) {
                    int mouseListY = mouseY - this.top - this.headerHeight + (int)this.scrollDistance - border;
                    int slotIndex = mouseListY / this.slotHeight;
                    if (mouseX >= entryLeft && mouseX <= entryRight && slotIndex >= 0 && mouseListY >= 0 && slotIndex < listLength) {
                        this.elementClicked(slotIndex, slotIndex == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L);
                        this.selectedIndex = slotIndex;
                        this.lastClickTime = System.currentTimeMillis();
                    } else if (mouseX >= entryLeft && mouseX <= entryRight && mouseListY < 0) {
                        this.clickHeader(mouseX - entryLeft, mouseY - this.top + (int)this.scrollDistance - border);
                    }
                    if (mouseX >= scrollBarLeft && mouseX <= scrollBarRight) {
                        int var13;
                        this.scrollFactor = -1.0f;
                        int scrollHeight = this.getContentHeight() - viewHeight - border;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        if ((var13 = (int)((float)(viewHeight * viewHeight) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > viewHeight - border * 2) {
                            var13 = viewHeight - border * 2;
                        }
                        this.scrollFactor /= (float)(viewHeight - var13) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        ScaledResolution res = new ScaledResolution(this.client);
        double scaleW = (double)this.client.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.client.field_71440_d / res.func_78324_d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.client.field_71440_d - (double)this.bottom * scaleH)), (int)((int)((double)this.listWidth * scaleW)), (int)((int)((double)viewHeight * scaleH)));
        if (this.client.field_71441_e != null) {
            this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            this.client.field_71446_o.func_110577_a(Gui.field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_187315_a((double)((float)this.left / 32.0f), (double)((float)(this.bottom + (int)this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            worldr.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_187315_a((double)((float)this.right / 32.0f), (double)((float)(this.bottom + (int)this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            worldr.func_181662_b((double)this.right, (double)this.top, 0.0).func_187315_a((double)((float)this.right / 32.0f), (double)((float)(this.top + (int)this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            worldr.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a((double)((float)this.left / 32.0f), (double)((float)(this.top + (int)this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            tess.func_78381_a();
        }
        int baseY = this.top + border - (int)this.scrollDistance;
        if (this.hasHeader) {
            this.drawHeader(entryRight, baseY, tess);
        }
        for (int slotIdx = 0; slotIdx < listLength; ++slotIdx) {
            int slotTop = baseY + slotIdx * this.slotHeight + this.headerHeight;
            int slotBuffer = this.slotHeight - border;
            if (slotTop > this.bottom || slotTop + slotBuffer < this.top) continue;
            if (this.highlightSelected && this.isSelected(slotIdx)) {
                int min = this.left;
                int max = entryRight;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldr.func_181662_b((double)min, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)max, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)max, (double)(slotTop - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)min, (double)(slotTop - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldr.func_181662_b((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldr.func_181662_b((double)(max - 1), (double)(slotTop - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldr.func_181662_b((double)(min + 1), (double)(slotTop - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.drawSlot(slotIdx, entryRight, slotTop, slotBuffer, tess);
        }
        GlStateManager.func_179097_i();
        int extraHeight = this.getContentHeight() + border - viewHeight;
        if (extraHeight > 0) {
            int barTop;
            int height = viewHeight * viewHeight / this.getContentHeight();
            if (height < 32) {
                height = 32;
            }
            if (height > viewHeight - border * 2) {
                height = viewHeight - border * 2;
            }
            if ((barTop = (int)this.scrollDistance * (viewHeight - height) / extraHeight + this.top) < this.top) {
                barTop = this.top;
            }
            GlStateManager.func_179090_x();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)(barTop + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + height - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)(barTop + height - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        this.drawScreen(mouseX, mouseY);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)3089);
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        GuiUtils.drawGradientRect((int)0, (int)left, (int)top, (int)right, (int)bottom, (int)color1, (int)color2);
    }
}

