/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.mainmenu.screens;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.base.AunisGuiButton;
import mrjake.aunis.gui.mainmenu.screens.modlist.AunisGuiScrollingList;
import mrjake.aunis.gui.mainmenu.screens.modlist.AunisGuiSlotModList;
import mrjake.aunis.gui.mainmenu.screens.options.AunisLanguageOptions;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.sound.AunisSoundHelperClient;
import mrjake.aunis.sound.SoundPositionedEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class AunisModListGui
extends GuiModList {
    protected static float animationStage = 0.0f;
    protected final float ringAnimationStepSetting = 0.3f;
    protected float ringAnimationStep = 0.0f;
    protected float ringAnimationSpeed = 1.0f;
    protected final boolean speedUpGate = true;
    protected AunisLanguageOptions.List list;
    protected BiomeOverlayEnum overlay;
    protected float screenCenterHeight = (float)this.field_146295_m / 2.0f;
    protected float screenCenterWidth = (float)this.field_146294_l / 2.0f;
    protected List<GuiButton> aunisButtonList = new ArrayList<GuiButton>();
    protected static final ResourceLocation BACKGROUND_TEXTURE = AunisConfig.mainMenuConfig.disableAunisMainMenu ? null : new ResourceLocation("aunis", "textures/gui/mainmenu/background.jpg");
    protected float kawooshState = 0.0f;
    protected float gateZoom = 0.0f;
    protected float gatePos = 0.0f;
    protected float gatePosY = 0.0f;
    protected boolean isUnloading = false;
    protected GuiScreen mainMenu;
    protected AunisGuiSlotModList modList;
    protected ArrayList<ModContainer> mods;
    protected AunisGuiScrollingList modInfo;
    protected ModContainer selectedMod;
    protected int selected = -1;
    protected int listWidth;
    protected AunisGuiButton configModButton;
    protected AunisGuiButton disableModButton;
    protected int field_146287_f;
    protected int field_146298_h;
    protected long field_146288_g;
    protected int buttonMargin = 1;
    protected int numButtons = SortType.values().length;
    protected String lastFilterText = "";
    protected GuiTextField search;
    protected boolean sorted = false;
    protected SortType sortType = SortType.NORMAL;

    @SubscribeEvent
    public static void onSounds(PlaySoundEvent event) {
        event.setResultSound(null);
    }

    public AunisModListGui(GuiScreen mainMenu, BiomeOverlayEnum overlay) {
        super(mainMenu);
        this.mainMenu = mainMenu;
        this.mods = new ArrayList();
        this.overlay = overlay;
        FMLClientHandler.instance().addSpecialModEntries(this.mods);
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod.getMetadata() != null && mod.getMetadata().parentMod == null && !Strings.isNullOrEmpty((String)mod.getMetadata().parent)) {
                String parentMod = mod.getMetadata().parent;
                ModContainer parentContainer = (ModContainer)Loader.instance().getIndexedModList().get(parentMod);
                if (parentContainer != null) {
                    mod.getMetadata().parentMod = parentContainer;
                    parentContainer.getMetadata().childMods.add(mod);
                    continue;
                }
            } else if (mod.getMetadata() != null && mod.getMetadata().parentMod != null) continue;
            this.mods.add(mod);
        }
    }

    public Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void func_73866_w_() {
        this.screenCenterHeight = (float)this.field_146295_m / 2.0f;
        this.screenCenterWidth = (float)this.field_146294_l / 2.0f;
        this.aunisButtonList.clear();
        int slotHeight = 35;
        for (ModContainer mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.field_146289_q.func_78256_a(mod.getName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.field_146289_q.func_78256_a(mod.getVersion()) + 5 + slotHeight);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.modList = new AunisGuiSlotModList(this, this.mods, this.listWidth, slotHeight);
        this.aunisButtonList.add(new AunisGuiButton(6, (this.modList.right + this.field_146294_l) / 2 - 100, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.configModButton = new AunisGuiButton(20, 10, this.field_146295_m - 49, this.listWidth, 20, "Config");
        this.disableModButton = new AunisGuiButton(21, 10, this.field_146295_m - 27, this.listWidth, 20, "Disable");
        this.aunisButtonList.add(this.configModButton);
        this.aunisButtonList.add(this.disableModButton);
        this.search = new GuiTextField(0, this.getFontRenderer(), 12, this.modList.bottom + 17, this.modList.listWidth - 4, 14);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        int width = this.modList.listWidth / this.numButtons;
        int x = 10;
        int y = 10;
        AunisGuiButton normalSort = new AunisGuiButton(SortType.NORMAL.buttonID, x, y, width - this.buttonMargin, 20, I18n.func_135052_a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.field_146124_l = false;
        this.aunisButtonList.add(normalSort);
        this.aunisButtonList.add(new AunisGuiButton(SortType.A_TO_Z.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "A-Z"));
        this.aunisButtonList.add(new AunisGuiButton(SortType.Z_TO_A.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "Z-A"));
        this.updateCache();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            SortType type = SortType.getTypeForButton(button);
            if (type != null) {
                for (GuiButton b : this.aunisButtonList) {
                    if (SortType.getTypeForButton(b) == null) continue;
                    b.field_146124_l = true;
                }
                button.field_146124_l = false;
                this.sorted = false;
                this.sortType = type;
                this.mods = this.modList.getMods();
            } else {
                switch (button.field_146127_k) {
                    case 6: {
                        this.isUnloading = true;
                        return;
                    }
                    case 20: {
                        try {
                            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                            GuiScreen newScreen = guiFactory.createConfigGui((GuiScreen)this);
                            this.field_146297_k.func_147108_a(newScreen);
                            break;
                        }
                        catch (Exception e) {
                            FMLLog.log.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selectedMod.getModId(), (Object)e);
                        }
                    }
                }
            }
        }
    }

    public void updateRingSpeed() {
        if (!AunisConfig.mainMenuConfig.gateRotation) {
            return;
        }
        if (this.ringAnimationSpeed < 1.0f) {
            this.ringAnimationSpeed += 0.05f;
        }
        this.ringAnimationStep = 0.3f * this.ringAnimationSpeed;
        animationStage += this.ringAnimationStep;
    }

    public void updateSound() {
        AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(1, 0, 0), SoundPositionedEnum.MAINMENU_MUSIC, AunisConfig.mainMenuConfig.playMusic);
        AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 0, 1), SoundPositionedEnum.MAINMENU_RING_ROLL, AunisConfig.mainMenuConfig.gateRotation && this.kawooshState == 0.0f && this.ringAnimationSpeed > 0.0f);
    }

    public void updateAnimation() {
        this.screenCenterHeight = (float)this.field_146295_m / 2.0f;
        this.screenCenterWidth = (float)this.field_146294_l / 2.0f;
        if (this.gateZoom == 0.0f) {
            this.gateZoom = (float)this.field_146295_m / 10.0f - 3.0f;
        }
        if (this.gatePos == 0.0f) {
            this.gatePos = (float)this.field_146294_l / 2.0f;
        }
        if (this.gatePosY == 0.0f) {
            this.gatePosY = (float)this.field_146294_l / 2.0f;
        }
        float step = 8.0f;
        if (!this.isUnloading) {
            if (this.gatePos < (float)this.field_146294_l - 54.0f) {
                this.gatePos += step * 4.0f;
            }
            if (this.gatePosY < 54.0f) {
                this.gatePosY += step * 4.0f;
            }
            if (this.gateZoom < (float)this.field_146294_l / 6.0f) {
                this.gateZoom += step;
            }
            if (this.gatePos > (float)this.field_146294_l - 57.0f) {
                this.gatePos -= step * 4.0f;
            }
            if (this.gatePosY > 57.0f) {
                this.gatePosY -= step * 4.0f;
            }
            if (this.gateZoom > (float)this.field_146294_l / 6.0f + 5.0f) {
                this.gateZoom -= step;
            }
        } else {
            if (this.gatePos > 0.0f) {
                this.gatePos -= step * 4.0f;
            }
            if (this.gatePosY > 0.0f) {
                this.gatePosY -= step * 4.0f;
            }
            if (this.gateZoom > 0.0f) {
                this.gateZoom -= step;
            }
            if (this.gatePosY + (step * 4.0f + 25.0f) <= (float)this.field_146295_m / 2.0f) {
                this.field_146297_k.func_147108_a(this.mainMenu);
            }
        }
        if (animationStage > 360.0f) {
            animationStage = 0.0f;
        }
        this.updateRingSpeed();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.updateAnimation();
        this.updateSound();
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        AunisModListGui.func_152125_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (int)this.field_146294_l, (int)this.field_146295_m, (float)this.field_146294_l, (float)this.field_146295_m);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179090_x();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179109_b((float)this.gatePos, (float)this.gatePosY, (float)0.0f);
        GlStateManager.func_179152_a((float)this.gateZoom, (float)this.gateZoom, (float)this.gateZoom);
        GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        ElementEnum.MILKYWAY_GATE_MAINMENU.bindTextureAndRender(this.overlay);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179114_b((float)animationStage, (float)0.0f, (float)0.0f, (float)1.0f);
        ElementEnum.MILKYWAY_RING_MAINMENU.bindTextureAndRender(this.overlay);
        GlStateManager.func_179121_F();
        for (int i = 0; i < 9; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.03f);
            GlStateManager.func_179114_b((float)ChevronEnum.valueOf((int)i).rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            ElementEnum.MILKYWAY_CHEVRON_FRAME_MAINMENU.bindTextureAndRender(this.overlay);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_LIGHT_MAINMENU.bindTextureAndRender(this.overlay);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_MOVING_MAINMENU.bindTextureAndRender(this.overlay);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179121_F();
        if (!this.isUnloading) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179098_w();
            this.modList.drawScreen(mouseX, mouseY, partialTicks);
            if (this.modInfo != null) {
                this.modInfo.drawScreen(mouseX, mouseY, partialTicks);
            }
            int left = (this.field_146294_l - this.listWidth - 38) / 2 + this.listWidth + 30;
            this.func_73732_a(this.field_146289_q, "Mod List", left, 16, 0xFFFFFF);
            for (GuiButton guiButton : this.aunisButtonList) {
                ((AunisGuiButton)guiButton).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            }
            for (GuiLabel guiLabel : this.field_146293_o) {
                guiLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
            }
            String text = I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]);
            int x = (10 + this.modList.right) / 2 - this.getFontRenderer().func_78256_a(text) / 2;
            this.getFontRenderer().func_78276_b(text, x, this.modList.bottom + 5, 0xFFFFFF);
            this.search.func_146194_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179121_F();
        }
    }

    private void updateCache() {
        this.configModButton.field_146125_m = false;
        this.disableModButton.field_146125_m = false;
        this.modInfo = null;
        if (this.selectedMod == null) {
            return;
        }
        ResourceLocation logoPath = null;
        Dimension logoDims = new Dimension(0, 0);
        ArrayList<String> lines = new ArrayList<String>();
        ForgeVersion.CheckResult vercheck = ForgeVersion.getResult((ModContainer)this.selectedMod);
        String logoFile = this.selectedMod.getMetadata().logoFile;
        if (!logoFile.isEmpty()) {
            TextureManager tm = this.field_146297_k.func_110434_K();
            IResourcePack pack = FMLClientHandler.instance().getResourcePackFor(this.selectedMod.getModId());
            try {
                BufferedImage logo = null;
                if (pack != null) {
                    logo = pack.func_110586_a();
                } else {
                    InputStream logoResource = ((Object)((Object)this)).getClass().getResourceAsStream(logoFile);
                    if (logoResource != null) {
                        logo = TextureUtil.func_177053_a((InputStream)logoResource);
                    }
                }
                if (logo != null) {
                    logoPath = tm.func_110578_a("modlogo", new DynamicTexture(logo));
                    logoDims = new Dimension(logo.getWidth(), logo.getHeight());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.selectedMod.getMetadata().autogenerated) {
            this.disableModButton.field_146125_m = true;
            this.disableModButton.field_146124_l = true;
            this.disableModButton.packedFGColour = 0;
            ModContainer.Disableable disableable = this.selectedMod.canBeDisabled();
            if (disableable == ModContainer.Disableable.RESTART) {
                this.disableModButton.packedFGColour = 0xFF3377;
            } else if (disableable != ModContainer.Disableable.YES) {
                this.disableModButton.field_146124_l = false;
            }
            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
            this.configModButton.field_146125_m = true;
            this.configModButton.field_146124_l = false;
            if (guiFactory != null) {
                this.configModButton.field_146124_l = guiFactory.hasConfigGui();
            }
            lines.add(this.selectedMod.getMetadata().name);
            lines.add(String.format("Version: %s (%s)", this.selectedMod.getDisplayVersion(), this.selectedMod.getVersion()));
            lines.add(String.format("Mod ID: '%s' Mod State: %s", this.selectedMod.getModId(), Loader.instance().getModState(this.selectedMod)));
            if (!this.selectedMod.getMetadata().credits.isEmpty()) {
                lines.add("Credits: " + this.selectedMod.getMetadata().credits);
            }
            lines.add("Authors: " + this.selectedMod.getMetadata().getAuthorList());
            lines.add("URL: " + this.selectedMod.getMetadata().url);
            if (this.selectedMod.getMetadata().childMods.isEmpty()) {
                lines.add("No child mods for this mod");
            } else {
                lines.add("Child mods: " + this.selectedMod.getMetadata().getChildModList());
            }
            if (vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                lines.add("Update Available: " + (vercheck.url == null ? "" : vercheck.url));
            }
            lines.add(null);
            lines.add(this.selectedMod.getMetadata().description);
        } else {
            lines.add(TextFormatting.WHITE + this.selectedMod.getName());
            lines.add(TextFormatting.WHITE + "Version: " + this.selectedMod.getVersion());
            lines.add(TextFormatting.WHITE + "Mod State: " + Loader.instance().getModState(this.selectedMod));
            if (vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                lines.add("Update Available: " + (vercheck.url == null ? "" : vercheck.url));
            }
            lines.add(null);
            lines.add(TextFormatting.RED + "No mod information found");
            lines.add(TextFormatting.RED + "Ask your mod author to provide a mod mcmod.info file");
        }
        if ((vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) && vercheck.changes.size() > 0) {
            lines.add(null);
            lines.add("Changes:");
            for (Map.Entry entry : vercheck.changes.entrySet()) {
                lines.add("  " + entry.getKey() + ":");
                lines.add((String)entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo = new Info(this.field_146294_l - this.listWidth - 30, lines, logoPath, logoDims);
    }

    public void func_73876_c() {
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.mods.sort(this.sortType);
            this.selected = this.modList.selectedIndex = this.mods.indexOf(this.selectedMod);
            this.sorted = true;
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        if (button == 0) {
            for (int i = 0; i < this.aunisButtonList.size(); ++i) {
                GuiButton guibutton = this.aunisButtonList.get(i);
                if (!guibutton.func_146116_c(this.field_146297_k, x, y)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.aunisButtonList);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.field_146290_a = guibutton = event.getButton();
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.aunisButtonList));
            }
        }
        this.search.func_146192_a(x, y, button);
        if (button == 1 && x >= this.search.field_146209_f && x < this.search.field_146209_f + this.search.field_146218_h && y >= this.search.field_146210_g && y < this.search.field_146210_g + this.search.field_146219_i) {
            this.search.func_146180_a("");
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int k = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            if (this.field_146297_k.field_71474_y.field_85185_A && this.field_146298_h++ > 0) {
                return;
            }
            this.field_146287_f = k;
            this.field_146288_g = Minecraft.func_71386_F();
            this.func_73864_a(i, j, this.field_146287_f);
        } else if (k != -1) {
            if (this.field_146297_k.field_71474_y.field_85185_A && --this.field_146298_h > 0) {
                return;
            }
            this.field_146287_f = -1;
            this.func_146286_b(i, j, k);
        } else if (this.field_146287_f != -1 && this.field_146288_g > 0L) {
            long l = Minecraft.func_71386_F() - this.field_146288_g;
            this.func_146273_a(i, j, this.field_146287_f, l);
        }
        if (this.modInfo != null) {
            this.modInfo.handleMouseInput(mouseX, mouseY);
        }
        this.modList.handleMouseInput(mouseX, mouseY);
    }

    public void selectModIndex(int index) {
        if (index == this.selected) {
            return;
        }
        this.selected = index;
        this.selectedMod = index >= 0 && index <= this.mods.size() ? this.mods.get(this.selected) : null;
        this.updateCache();
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
        this.search.func_146201_a(c, keyCode);
    }

    public boolean modIndexSelected(int index) {
        return index == this.selected;
    }

    private void reloadMods() {
        ArrayList<ModContainer> mods = this.modList.getMods();
        mods.clear();
        for (ModContainer m : Loader.instance().getActiveModList()) {
            if (!m.getName().toLowerCase().contains(this.search.func_146179_b().toLowerCase()) || m.getMetadata().parentMod != null) continue;
            mods.add(m);
        }
        this.mods = mods;
        this.lastFilterText = this.search.func_146179_b();
    }

    public class Info
    extends AunisGuiScrollingList {
        @Nullable
        private final ResourceLocation logoPath;
        private final Dimension logoDims;
        private final List<ITextComponent> lines;

        public Info(int width, @Nullable List<String> lines, ResourceLocation logoPath, Dimension logoDims) {
            super(AunisModListGui.this.getMinecraftInstance(), width, AunisModListGui.this.field_146295_m, 32, AunisModListGui.this.field_146295_m - 88 + 4, AunisModListGui.this.listWidth + 20, 60, AunisModListGui.this.field_146294_l, AunisModListGui.this.field_146295_m);
            this.lines = this.resizeContent(lines);
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        @Override
        protected int getSize() {
            return 0;
        }

        @Override
        protected void elementClicked(int index, boolean doubleClick) {
        }

        @Override
        protected boolean isSelected(int index) {
            return false;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        }

        private List<ITextComponent> resizeContent(List<String> lines) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                int maxTextLength = this.listWidth - 8;
                if (maxTextLength < 0) continue;
                ret.addAll(GuiUtilRenderComponents.func_178908_a((ITextComponent)chat, (int)maxTextLength, (FontRenderer)AunisModListGui.this.field_146289_q, (boolean)false, (boolean)true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = 0;
            if (this.logoPath != null) {
                double scaleX = (double)this.logoDims.width / 200.0;
                double scaleY = (double)this.logoDims.height / 65.0;
                double scale = 1.0;
                if (scaleX > 1.0 || scaleY > 1.0) {
                    scale = 1.0 / Math.max(scaleX, scaleY);
                }
                this.logoDims.width = (int)((double)this.logoDims.width * scale);
                this.logoDims.height = (int)((double)this.logoDims.height * scale);
                height += this.logoDims.height;
                height += 10;
            }
            if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
            int top = relativeY;
            if (this.logoPath != null) {
                GlStateManager.func_179147_l();
                AunisModListGui.this.field_146297_k.field_71446_o.func_110577_a(this.logoPath);
                BufferBuilder wr = tess.func_178180_c();
                int offset = this.left + this.listWidth / 2 - this.logoDims.width / 2;
                wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                wr.func_181662_b((double)offset, (double)(top + this.logoDims.height), (double)AunisModListGui.this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)(top + this.logoDims.height), (double)AunisModListGui.this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)top, (double)AunisModListGui.this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
                wr.func_181662_b((double)offset, (double)top, (double)AunisModListGui.this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179084_k();
                top += this.logoDims.height + 10;
            }
            for (ITextComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.func_179147_l();
                    AunisModListGui.this.field_146289_q.func_175063_a(line.func_150254_d(), (float)(this.left + 4), (float)top, 0xFFFFFF);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                top += 10;
            }
        }

        @Override
        protected void clickHeader(int x, int y) {
            int offset = y;
            if (this.logoPath != null) {
                offset -= this.logoDims.height + 10;
            }
            if (offset <= 0) {
                return;
            }
            int lineIdx = offset / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            ITextComponent line = this.lines.get(lineIdx);
            if (line != null) {
                int k = -4;
                for (ITextComponent part : line) {
                    if (!(part instanceof TextComponentString) || (k += AunisModListGui.this.field_146289_q.func_78256_a(((TextComponentString)part).func_150265_g())) < x) continue;
                    AunisModListGui.this.func_175276_a(part);
                    break;
                }
            }
        }
    }

    private static enum SortType implements Comparator<ModContainer>
    {
        NORMAL(24),
        A_TO_Z(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        private final int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        @Nullable
        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.field_146127_k) continue;
                return t;
            }
            return null;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            String name1 = StringUtils.func_76338_a((String)o1.getName()).toLowerCase();
            String name2 = StringUtils.func_76338_a((String)o2.getName()).toLowerCase();
            return this.compare(name1, name2);
        }
    }
}

