/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.mainmenu;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mrjake.aunis.Aunis;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.base.AunisGuiButton;
import mrjake.aunis.gui.mainmenu.GetUpdate;
import mrjake.aunis.gui.mainmenu.screens.AunisModListGui;
import mrjake.aunis.gui.mainmenu.screens.AunisOptionsGui;
import mrjake.aunis.gui.mainmenu.screens.options.AunisLanguageOptions;
import mrjake.aunis.loader.ElementEnum;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.renderer.stargate.StargateRendererStatic;
import mrjake.aunis.sound.AunisSoundHelperClient;
import mrjake.aunis.sound.SoundPositionedEnum;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AunisMainMenu
extends GuiMainMenu {
    protected static final String VERSION = "1.12.2-4.9.4.2".replace("1.12.2-", "");
    protected static float animationStage = 0.0f;
    protected static final float ringAnimationStepSetting = 0.3f;
    protected static float ringAnimationStep = 0.0f;
    protected static float ringAnimationSpeed = 1.0f;
    protected static boolean speedUpGate = true;
    protected float chevronLastAnimationStage = 0.0f;
    protected boolean chevronsActive = false;
    protected boolean chevronShout = false;
    protected boolean chevronShoutColapsing = false;
    protected int chevronShoutTiming = 0;
    protected static final int chevronShoutTimingSetting = 16;
    protected boolean chevronSound1 = false;
    protected boolean chevronSound2 = false;
    protected boolean chevronSound3 = false;
    protected BiomeOverlayEnum[] overlays = new BiomeOverlayEnum[]{BiomeOverlayEnum.AGED, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.SOOTY, BiomeOverlayEnum.NORMAL};
    protected BiomeOverlayEnum overlay;
    protected float screenCenterHeight;
    protected float screenCenterWidth;
    protected List<GuiButton> aunisButtonList;
    protected List<GuiButton> versionButtons;
    protected List<GuiButton> afterDownloadButtons;
    protected List<GuiButton> anyButton;
    protected static final ResourceLocation BACKGROUND_TEXTURE = AunisConfig.mainMenuConfig.disableAunisMainMenu ? null : new ResourceLocation("aunis", "textures/gui/mainmenu/background.jpg");
    protected static ResourceLocation EVENT_HORIZON_TEXTURE = new ResourceLocation("aunis", "textures/gui/mainmenu/event_horizon.jpg");
    protected static final String LATEST = GetUpdate.checkForUpdate(VERSION);
    protected static int showVersionAlert = 0;
    protected String nextEvent;
    protected boolean renderKawoosh;
    protected boolean renderButtonsAndStuff;
    protected float renderButtonsAlpha;
    protected float kawooshState;
    protected float gateZoom;
    protected int clickedButton;
    static StargateRendererStatic.InnerCircle innerCircle = new StargateRendererStatic.InnerCircle();
    static List<StargateRendererStatic.QuadStrip> quadStrips = new ArrayList<StargateRendererStatic.QuadStrip>();
    protected double percentDownloaded;

    public AunisMainMenu() {
        this.overlay = this.getNextBiomeOverlay(AunisConfig.mainMenuConfig.changingGateOverlay, false);
        this.screenCenterHeight = (float)this.field_146295_m / 2.0f;
        this.screenCenterWidth = (float)this.field_146294_l / 2.0f;
        this.aunisButtonList = new ArrayList<GuiButton>();
        this.versionButtons = new ArrayList<GuiButton>();
        this.afterDownloadButtons = new ArrayList<GuiButton>();
        this.anyButton = new ArrayList<GuiButton>();
        this.nextEvent = "------";
        this.renderKawoosh = false;
        this.renderButtonsAndStuff = true;
        this.renderButtonsAlpha = 0.0f;
        this.kawooshState = 0.0f;
        this.gateZoom = 1.0f;
        this.clickedButton = 0;
        this.percentDownloaded = 0.0;
    }

    public void deleteEvent() {
        this.nextEvent = "------";
    }

    public void updateLastChevron() {
        if (this.chevronShout) {
            this.nextEvent = "Animate chevron";
            if (!this.chevronSound3) {
                AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 2, 0), SoundPositionedEnum.MAINMENU_CHEVRON_SHUT, true);
                this.chevronSound3 = true;
            }
            if (this.chevronLastAnimationStage >= 0.15f || this.chevronShoutColapsing) {
                if (this.chevronShoutTiming > 16) {
                    this.chevronShoutColapsing = true;
                    this.chevronLastAnimationStage -= 0.02f;
                    this.nextEvent = "Top chevron up";
                } else if (this.chevronShoutTiming == 8) {
                    if (!this.chevronSound1) {
                        AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 2, 0), SoundPositionedEnum.MAINMENU_CHEVRON_OPEN, true);
                        this.chevronSound1 = true;
                        this.nextEvent = "Top chevron waiting";
                    }
                    ++this.chevronShoutTiming;
                } else {
                    ++this.chevronShoutTiming;
                }
            } else {
                this.chevronLastAnimationStage += 0.02f;
                this.nextEvent = "Top chevron down";
            }
            if (this.chevronLastAnimationStage < 0.0f) {
                if (!this.chevronSound2) {
                    AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(1, 2, 0), SoundPositionedEnum.MAINMENU_CHEVRON_SHUT, true);
                    this.chevronSound2 = true;
                }
                this.nextEvent = "Top chevron reset";
                if (!this.chevronsActive) {
                    this.getNextBiomeOverlay(AunisConfig.mainMenuConfig.changingGateOverlay, true);
                }
                this.chevronShoutTiming = 0;
                this.chevronLastAnimationStage = 0.0f;
                this.chevronShout = false;
                this.chevronSound1 = false;
                this.chevronSound2 = false;
                this.chevronSound3 = false;
                this.chevronShoutColapsing = false;
                if (this.kawooshState == 0.0f) {
                    speedUpGate = true;
                }
                this.deleteEvent();
            }
        }
    }

    public void updateRingSpeed() {
        if (!AunisConfig.mainMenuConfig.gateRotation) {
            return;
        }
        if (!speedUpGate) {
            if (ringAnimationSpeed > 0.0f) {
                ringAnimationSpeed -= 0.02f;
            }
            if (ringAnimationSpeed < 0.0f) {
                ringAnimationSpeed = 0.0f;
            }
            if (ringAnimationSpeed < 0.05f && this.kawooshState == 0.0f && !this.chevronShout) {
                this.chevronShout = true;
            }
        } else if (ringAnimationSpeed < 1.0f) {
            ringAnimationSpeed += 0.02f;
        }
        ringAnimationStep = 0.3f * ringAnimationSpeed;
        animationStage += ringAnimationStep;
    }

    public BiomeOverlayEnum getNextBiomeOverlay(boolean doIt, boolean updateGui) {
        this.nextEvent = "Changing overlay";
        BiomeOverlayEnum over = this.overlay;
        if (doIt) {
            while (over == this.overlay) {
                over = this.overlays[new Random().nextInt(this.overlays.length)];
            }
            this.overlay = over;
        } else if (this.overlay == null) {
            this.overlay = BiomeOverlayEnum.NORMAL;
        }
        if (updateGui) {
            this.func_73866_w_();
        }
        return this.overlay;
    }

    public void updateSound() {
        if (this.field_146297_k.field_71474_y.func_74297_c(GameSettings.Options.AUTO_JUMP).equals("Auto-Jump: ON")) {
            this.field_146297_k.field_71474_y.func_74306_a(GameSettings.Options.AUTO_JUMP, 1);
        }
        AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(1, 0, 0), SoundPositionedEnum.MAINMENU_MUSIC, AunisConfig.mainMenuConfig.playMusic);
        AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 0, 1), SoundPositionedEnum.MAINMENU_RING_ROLL, AunisConfig.mainMenuConfig.gateRotation && this.kawooshState == 0.0f && ringAnimationSpeed > 0.0f);
    }

    public void updateAnimation() {
        if (animationStage > 360.0f) {
            animationStage = 0.0f;
        }
        if (animationStage > 352.0f && animationStage < 353.0f || animationStage > 172.0f && animationStage < 173.0f) {
            speedUpGate = false;
        }
        this.updateRingSpeed();
    }

    public void loadGame() {
        speedUpGate = false;
        if (ringAnimationSpeed <= 0.05f) {
            this.renderButtonsAndStuff = false;
            this.chevronsActive = true;
            float step = 0.008f;
            if (this.kawooshState == 0.0f) {
                this.nextEvent = "Switching screens...";
                this.kawooshState += step;
                AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 0, 1), SoundPositionedEnum.MAINMENU_RING_ROLL, false);
            } else if (this.kawooshState < 0.51f) {
                this.kawooshState += step;
            } else if (this.kawooshState > 0.5f && this.kawooshState < 0.81f) {
                this.kawooshState += step;
                this.renderEventHorizon(true);
                switch (this.clickedButton) {
                    case 1: {
                        this.nextEvent = "Switching to singleplayer...";
                        break;
                    }
                    case 2: {
                        this.nextEvent = "Switching to multiplayer...";
                        break;
                    }
                    case 4: {
                        this.nextEvent = "Shutting down minecraft client...";
                        break;
                    }
                    default: {
                        this.nextEvent = "Button not recognized! (" + this.clickedButton + ")";
                    }
                }
                AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 0, 0), SoundPositionedEnum.MAINMENU_GATE_OPEN, true);
            } else if (this.kawooshState > 0.8f && this.kawooshState < 1.61f) {
                AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(1, 0, 1), SoundPositionedEnum.WORMHOLE_LOOP, true);
                this.renderEventHorizon(false);
                this.kawooshState += step + 0.008f;
                this.gateZoom += 0.1f;
            } else if (this.kawooshState > 1.6f && this.kawooshState < 2.0f) {
                this.renderEventHorizon(false);
                this.kawooshState += step;
                this.gateZoom += this.gateZoom * 2.0f / 10.0f;
            } else if (this.kawooshState > 1.99f && (double)this.kawooshState < 2.2) {
                switch (this.clickedButton) {
                    case 1: {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldSelection((GuiScreen)this));
                        break;
                    }
                    case 2: {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer((GuiScreen)this));
                        break;
                    }
                    case 4: {
                        this.field_146297_k.func_71400_g();
                        break;
                    }
                    default: {
                        Aunis.logger.error("Wrong button clicked!!! This is a bug! (" + this.clickedButton + ")");
                    }
                }
                this.kawooshState = 2.2f;
                this.renderKawoosh = false;
                AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(1, 0, 1), SoundPositionedEnum.WORMHOLE_LOOP, false);
                AunisSoundHelperClient.playPositionedSoundClientSide(new BlockPos(0, 0, 0), SoundPositionedEnum.MAINMENU_GATE_GO, true);
                this.renderButtonsAndStuff = true;
                this.clickedButton = 0;
            } else if (this.kawooshState == 2.2f) {
                this.kawooshState = 0.0f;
            }
        }
    }

    public void renderEventHorizon(boolean doKawoosh) {
        if (!doKawoosh) {
            quadStrips.clear();
            for (int i = 0; i < 16; ++i) {
                quadStrips.add(new StargateRendererStatic.QuadStrip(i));
            }
            GlStateManager.func_179094_E();
            this.field_146297_k.func_110434_K().func_110577_a(EVENT_HORIZON_TEXTURE);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            innerCircle.render(1.0f, false, Float.valueOf(1.0f), 0.0f, (byte)-1);
            for (StargateRendererStatic.QuadStrip strip : quadStrips) {
                strip.render(1.0f, false, Float.valueOf(1.0f), 0.0f, (byte)-1);
            }
            GlStateManager.func_179121_F();
        } else {
            quadStrips.clear();
            for (int i = 0; i < 16; ++i) {
                quadStrips.add(new StargateRendererStatic.QuadStrip(i));
            }
            GlStateManager.func_179094_E();
            this.field_146297_k.func_110434_K().func_110577_a(EVENT_HORIZON_TEXTURE);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            innerCircle.render(1.0f, true, Float.valueOf(1.0f), 0.0f, (byte)-1);
            for (StargateRendererStatic.QuadStrip strip : quadStrips) {
                strip.render(1.0f, true, Float.valueOf(1.0f), 0.0f, (byte)-1);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void checkDownloaded() {
        if (showVersionAlert != 4) {
            return;
        }
        this.percentDownloaded = GetUpdate.getPercents();
        if (this.percentDownloaded < 0.0) {
            this.percentDownloaded = 0.0;
        }
        if (this.percentDownloaded > 100.0) {
            this.percentDownloaded = 100.0;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.screenCenterHeight = (float)this.field_146295_m / 2.0f;
        this.screenCenterWidth = (float)this.field_146294_l / 2.0f;
        this.checkDownloaded();
        this.updateAnimation();
        this.updateSound();
        this.updateLastChevron();
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        AunisMainMenu.func_152125_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (int)this.field_146294_l, (int)this.field_146295_m, (float)this.field_146294_l, (float)this.field_146295_m);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179090_x();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)this.screenCenterHeight, (float)0.0f);
        GlStateManager.func_179152_a((float)(this.gateZoom + ((float)this.field_146295_m / 10.0f - 3.0f)), (float)(this.gateZoom + ((float)this.field_146295_m / 10.0f - 3.0f)), (float)(this.gateZoom + ((float)this.field_146295_m / 10.0f - 3.0f)));
        GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.renderKawoosh) {
            this.loadGame();
        } else {
            this.kawooshState = 0.0f;
            this.gateZoom = 1.0f;
            this.chevronsActive = false;
        }
        GlStateManager.func_179094_E();
        ElementEnum.MILKYWAY_GATE_MAINMENU.bindTextureAndRender(this.overlay);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179114_b((float)animationStage, (float)0.0f, (float)0.0f, (float)1.0f);
        ElementEnum.MILKYWAY_RING_MAINMENU.bindTextureAndRender(this.overlay);
        GlStateManager.func_179121_F();
        for (int i = 0; i < 9; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.03f);
            GlStateManager.func_179114_b((float)ChevronEnum.valueOf((int)i).rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            float chevronOffset = 0.0f;
            if (i == 8) {
                chevronOffset = this.chevronLastAnimationStage;
            }
            ElementEnum.MILKYWAY_CHEVRON_FRAME_MAINMENU.bindTextureAndRender(this.overlay);
            GlStateManager.func_179109_b((float)0.0f, (float)chevronOffset, (float)0.0f);
            if (i == 6 || i == 7 || !this.chevronsActive) {
                if (i == 8 && this.chevronShoutTiming > 8 && this.chevronShout) {
                    ElementEnum.MILKYWAY_CHEVRON_LIGHT_ACTIVE_MAINMENU.bindTextureAndRender(this.overlay);
                    GlStateManager.func_179109_b((float)0.0f, (float)(-2.0f * chevronOffset), (float)0.0f);
                    ElementEnum.MILKYWAY_CHEVRON_MOVING_ACTIVE_MAINMENU.bindTextureAndRender(this.overlay);
                } else {
                    ElementEnum.MILKYWAY_CHEVRON_LIGHT_MAINMENU.bindTextureAndRender(this.overlay);
                    GlStateManager.func_179109_b((float)0.0f, (float)(-2.0f * chevronOffset), (float)0.0f);
                    ElementEnum.MILKYWAY_CHEVRON_MOVING_MAINMENU.bindTextureAndRender(this.overlay);
                }
            } else {
                ElementEnum.MILKYWAY_CHEVRON_LIGHT_ACTIVE_MAINMENU.bindTextureAndRender(this.overlay);
                GlStateManager.func_179109_b((float)0.0f, (float)(-2.0f * chevronOffset), (float)0.0f);
                ElementEnum.MILKYWAY_CHEVRON_MOVING_ACTIVE_MAINMENU.bindTextureAndRender(this.overlay);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179121_F();
        String versionInfo = "Aunis version: " + VERSION;
        if (this.renderButtonsAndStuff) {
            if (this.renderButtonsAlpha < 1.0f && showVersionAlert != 1) {
                this.renderButtonsAlpha += 0.05f;
            }
            if (!LATEST.equals("false") && !LATEST.equals("Error was occurred while updating Aunis!") && AunisConfig.enableAutoUpdater) {
                versionInfo = versionInfo + " - Latest build: " + LATEST;
                if (showVersionAlert != 2 && showVersionAlert != 4) {
                    showVersionAlert = 1;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179098_w();
            GlStateManager.func_179109_b((float)6.0f, (float)((float)this.field_146295_m - 46.0f), (float)0.0f);
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Music credits: STARGATE SG-1 - Full Original Soundtrack OST", 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Aunis mod by: MrJake, MineDragonCZ_ and Matousss", 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, versionInfo, 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Note that the gate cannot be rendered perfectly here!", 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Copyright Mojang AB. Do not distribute!", 0, 0, 0xFFFFFF);
            GlStateManager.func_179090_x();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179094_E();
            GlStateManager.func_179098_w();
            GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)48.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
            this.func_73732_a(this.field_146289_q, "Aunis", 0, 0, 0xFFFFFF);
            GlStateManager.func_179090_x();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179098_w();
            GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)81.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            this.func_73732_a(this.field_146289_q, "All you need is stargate", 0, 0, 0xA4A4A4);
            GlStateManager.func_179090_x();
            GlStateManager.func_179121_F();
            for (GuiButton guiButton : this.aunisButtonList) {
                ((AunisGuiButton)guiButton).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            }
            for (GuiLabel guiLabel : this.field_146293_o) {
                guiLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
            if (showVersionAlert == 1) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179094_E();
                this.frame(0, 0, this.field_146294_l, this.field_146295_m, 3, -15197665, -14210253);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)(this.screenCenterHeight - 60.0f), (float)0.0f);
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                if (!LATEST.equals("Error was occurred while updating Aunis!")) {
                    this.func_73732_a(this.field_146289_q, "You are using out of date version of Aunis mod.", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
                    GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)(this.screenCenterHeight - 40.0f), (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "For your comfort, please update", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "your mod in your mods folder.", 0, 0, 0xFFFFFF);
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
                for (GuiButton guiButton : this.versionButtons) {
                    ((AunisGuiButton)guiButton).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
                }
                GlStateManager.func_179121_F();
            }
            if (showVersionAlert == 4) {
                if (this.percentDownloaded >= 100.0) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179094_E();
                    this.frame(0, 0, this.field_146294_l, this.field_146295_m, 3, -15197665, -14210253);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)(this.screenCenterHeight - 60.0f), (float)0.0f);
                    GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                    this.func_73732_a(this.field_146289_q, "Downloading Aunis", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
                    GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)(this.screenCenterHeight - 40.0f), (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "Downloading completed", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179109_b((float)0.0f, (float)20.0f, (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "Please restart minecraft:", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                    for (GuiButton guiButton : this.afterDownloadButtons) {
                        ((AunisGuiButton)guiButton).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
                    }
                } else {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179094_E();
                    this.frame(0, 0, this.field_146294_l, this.field_146295_m, 3, -15197665, -14210253);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)(this.screenCenterHeight - 60.0f), (float)0.0f);
                    GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                    this.func_73732_a(this.field_146289_q, "Downloading Aunis", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
                    GlStateManager.func_179109_b((float)this.screenCenterWidth, (float)(this.screenCenterHeight - 40.0f), (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "Please do not quit minecraft", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "before Aunis installs.", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "This process take usually about 5 minutes...", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179109_b((float)0.0f, (float)20.0f, (float)0.0f);
                    this.func_73732_a(this.field_146289_q, "Downloaded: " + this.percentDownloaded + "%", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179121_F();
            }
        }
        if (AunisConfig.mainMenuConfig.debugMode) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179098_w();
            GlStateManager.func_179109_b((float)6.0f, (float)(this.screenCenterHeight - 30.0f), (float)0.0f);
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Ring rotation: " + animationStage, 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Ring speed: " + ringAnimationStep + "deg/tick", 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Screen resolution: " + this.field_146294_l + "px x " + this.field_146295_m + "px", 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Screen center: " + this.screenCenterWidth + "px x " + this.screenCenterHeight + "px", 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Version alert state: " + showVersionAlert, 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Top chevron position: " + this.chevronLastAnimationStage, 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Active overlay: " + this.overlay.name(), 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Chevrons active? " + this.chevronsActive, 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Event horizon state: " + this.kawooshState, 0, 0, 0xFFFFFF);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            this.func_73731_b(this.field_146289_q, "Next event: " + this.nextEvent, 0, 0, 0xFFFFFF);
            GlStateManager.func_179090_x();
            GlStateManager.func_179121_F();
        }
    }

    protected void frame(int x, int y, int w, int h, int thickness, int borderColor, int background) {
        AunisMainMenu.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + thickness), (int)borderColor);
        AunisMainMenu.func_73734_a((int)x, (int)(y + h - thickness), (int)(x + w), (int)(y + h), (int)borderColor);
        AunisMainMenu.func_73734_a((int)x, (int)(y + thickness), (int)(x + thickness), (int)(y + h - thickness), (int)borderColor);
        AunisMainMenu.func_73734_a((int)(x + w - thickness), (int)(y + thickness), (int)(x + w), (int)(y + h - thickness), (int)borderColor);
        AunisMainMenu.func_73734_a((int)(x + thickness), (int)(y + thickness), (int)(x + w - thickness), (int)(y + h - thickness), (int)background);
    }

    public void func_73866_w_() {
        this.versionButtons.clear();
        this.versionButtons.add(new AunisGuiButton(21, this.field_146294_l / 2 - 100, this.field_146295_m - 75, 98, 20, "OK"));
        this.versionButtons.add(new AunisGuiButton(22, this.field_146294_l / 2 + 2, this.field_146295_m - 75, 98, 20, "Download"));
        this.afterDownloadButtons.clear();
        this.afterDownloadButtons.add(new AunisGuiButton(23, this.field_146294_l / 2 - 50, this.field_146295_m - 75, 100, 20, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0])));
        this.aunisButtonList.clear();
        int j = this.field_146295_m / 4 + 48;
        if (!AunisConfig.mainMenuConfig.disablePosButtons) {
            this.aunisButtonList.add(new AunisGuiButton(1, this.field_146294_l / 2 - 100, j, I18n.func_135052_a((String)"menu.singleplayer", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(2, this.field_146294_l / 2 - 100, j + 24, I18n.func_135052_a((String)"menu.multiplayer", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(20, this.field_146294_l / 2 - 100, j + 48, I18n.func_135052_a((String)"menu.about", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(6, this.field_146294_l - 6 - 98, 6, 98, 20, I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(0, 6, 6, 98, 20, I18n.func_135052_a((String)"menu.options", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(4, this.field_146294_l - 6 - 98, this.field_146295_m - 6 - 20, 98, 20, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(61, this.field_146294_l - 6 - 98, this.field_146295_m - 6 - 45, 98, 20, I18n.func_135052_a((String)"menu.gate_overlay", (Object[])new Object[0]) + ": " + this.overlay.name()));
            this.aunisButtonList.add(new AunisGuiButton(62, this.field_146294_l - 6 - 98, this.field_146295_m - 6 - 70, 98, 20, I18n.func_135052_a((String)"menu.music_toggle", (Object[])new Object[0]) + ": " + AunisConfig.mainMenuConfig.playMusic));
        } else {
            this.aunisButtonList.add(new AunisGuiButton(1, this.field_146294_l / 2 - 100, j, I18n.func_135052_a((String)"menu.singleplayer", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(2, this.field_146294_l / 2 - 100, j + 24, I18n.func_135052_a((String)"menu.multiplayer", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(20, this.field_146294_l / 2 - 100, j + 48, 98, 20, I18n.func_135052_a((String)"menu.about", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(6, this.field_146294_l / 2 + 2, j + 48, 98, 20, I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(0, this.field_146294_l / 2 - 100, j + 72, 98, 20, I18n.func_135052_a((String)"menu.options", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(4, this.field_146294_l / 2 + 2, j + 72, 98, 20, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0])));
            this.aunisButtonList.add(new AunisGuiButton(61, this.field_146294_l - 6 - 98, this.field_146295_m - 6 - 20, 98, 20, I18n.func_135052_a((String)"menu.gate_overlay", (Object[])new Object[0]) + ": " + this.overlay.name()));
            this.aunisButtonList.add(new AunisGuiButton(62, this.field_146294_l - 6 - 98, this.field_146295_m - 6 - 45, 98, 20, I18n.func_135052_a((String)"menu.music_toggle", (Object[])new Object[0]) + ": " + AunisConfig.mainMenuConfig.playMusic));
        }
        super.func_73866_w_();
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.field_146297_k.func_147108_a((GuiScreen)new AunisOptionsGui((GuiScreen)this, this.field_146297_k.field_71474_y, this.overlay));
                break;
            }
            case 1: {
                if (AunisConfig.mainMenuConfig.enableEventHorizon) {
                    this.clickedButton = 1;
                    this.renderKawoosh = true;
                    break;
                }
                this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldSelection((GuiScreen)this));
                break;
            }
            case 2: {
                if (AunisConfig.mainMenuConfig.enableEventHorizon) {
                    this.clickedButton = 2;
                    this.renderKawoosh = true;
                    break;
                }
                this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer((GuiScreen)this));
                break;
            }
            case 4: {
                if (AunisConfig.mainMenuConfig.enableEventHorizon) {
                    this.clickedButton = 4;
                    this.renderKawoosh = true;
                    break;
                }
                this.field_146297_k.func_71400_g();
                break;
            }
            case 5: {
                this.field_146297_k.func_147108_a((GuiScreen)new AunisLanguageOptions((GuiScreen)this, this.field_146297_k.field_71474_y, this.field_146297_k.func_135016_M(), this.overlay));
                break;
            }
            case 6: {
                this.field_146297_k.func_147108_a((GuiScreen)new AunisModListGui((GuiScreen)this, this.overlay));
                break;
            }
            case 20: {
                try {
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object, new URI("https://github.com/MineDragonCZ/Aunis1/wiki"));
                }
                catch (Exception e) {
                    Aunis.logger.debug("Couldn't open link", (Throwable)e);
                }
                break;
            }
            case 21: {
                showVersionAlert = 2;
                break;
            }
            case 22: {
                if (GetUpdate.updateMod(VERSION, "-alpha")) {
                    Aunis.warn("Updating Aunis automatically...");
                    showVersionAlert = 4;
                    break;
                }
                Aunis.warn("Could not update Aunis automatically! Opening website...");
                try {
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object, new URI(GetUpdate.getSiteContent("https://amazingworlds.eu/curseapi/1.12.2/?t=url")));
                }
                catch (Exception e) {
                    Aunis.logger.debug("Couldn't open link", (Throwable)e);
                }
                break;
            }
            case 23: {
                this.field_146297_k.func_71400_g();
            }
            case 61: {
                this.overlay = this.getNextBiomeOverlay(true, true);
                this.func_73866_w_();
                break;
            }
            case 62: {
                AunisConfig.mainMenuConfig.playMusic = !AunisConfig.mainMenuConfig.playMusic;
                this.func_73866_w_();
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.renderButtonsAndStuff) {
            GuiScreenEvent.ActionPerformedEvent.Pre event;
            GuiButton guibutton;
            int i;
            if (showVersionAlert != 1 && showVersionAlert != 4) {
                for (i = 0; i < this.aunisButtonList.size(); ++i) {
                    guibutton = this.aunisButtonList.get(i);
                    if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                    event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.aunisButtonList);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                    this.field_146290_a = guibutton = event.getButton();
                    guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                    this.func_146284_a(guibutton);
                    if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.aunisButtonList));
                }
            }
            if (showVersionAlert == 1) {
                for (i = 0; i < this.versionButtons.size(); ++i) {
                    guibutton = this.versionButtons.get(i);
                    if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                    event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.versionButtons);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                    this.field_146290_a = guibutton = event.getButton();
                    guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                    this.func_146284_a(guibutton);
                    if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.versionButtons));
                }
            }
            if (showVersionAlert == 4 && this.percentDownloaded >= 100.0) {
                for (i = 0; i < this.afterDownloadButtons.size(); ++i) {
                    guibutton = this.afterDownloadButtons.get(i);
                    if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                    event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.afterDownloadButtons);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                    this.field_146290_a = guibutton = event.getButton();
                    guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                    this.func_146284_a(guibutton);
                    if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.afterDownloadButtons));
                }
            }
        }
    }
}

