/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.entry;

import mrjake.aunis.gui.entry.AbstractAddressEntry;
import mrjake.aunis.gui.entry.AbstractEntry;
import mrjake.aunis.packet.gui.entry.EntryDataTypeEnum;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumHand;

public class UniverseEntry
extends AbstractAddressEntry {
    public static final int ADDRESS_WIDTH = 80;
    public static final int BUTTON_COUNT = 3;

    public UniverseEntry(Minecraft mc, int index, int maxIndex, EnumHand hand, String name, AbstractEntry.ActionListener reloadListener, SymbolTypeEnum type, StargateAddress addr, int maxSymbols) {
        super(mc, index, maxIndex, hand, name, reloadListener, type, addr, maxSymbols);
    }

    @Override
    public void renderAt(int dx, int dy, int mouseX, int mouseY, float partialTicks) {
        int width = 15;
        int height = 30;
        int xSpacing = 10;
        int addressWidth = 10 * this.maxSymbols + 5;
        int x = dx + (80 - addressWidth) / 2;
        for (int i = 0; i < this.maxSymbols; ++i) {
            SymbolInterface symbol = this.stargateAddress.get(i);
            UniverseEntry.renderSymbol(x, dy, 15, 30, symbol);
            x += 10;
        }
        super.renderAt(dx + 80 + 10, dy + 5, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getHeight() {
        return 30;
    }

    @Override
    protected int getMaxNameLength() {
        return 16;
    }

    @Override
    protected EntryDataTypeEnum getEntryDataType() {
        return EntryDataTypeEnum.UNIVERSE;
    }
}

