/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.entry;

import mrjake.aunis.gui.base.BetterButton;
import mrjake.aunis.gui.base.BetterTextField;
import mrjake.aunis.gui.entry.AbstractEntry;
import mrjake.aunis.item.oc.ItemOCMessage;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.gui.entry.EntryDataTypeEnum;
import mrjake.aunis.packet.gui.entry.OCActionEnum;
import mrjake.aunis.packet.gui.entry.OCActionToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OCEntry
extends AbstractEntry {
    public static final int ADDRESS_WIDTH = 222;
    public static final int PORT_WIDTH = 38;
    public static final int PARAM_WIDTH = 100;
    public static final int BUTTON_COUNT = 3;
    protected ItemOCMessage message;
    protected GuiTextField addressField;
    protected GuiTextField portField;
    protected GuiTextField paramField;
    protected BetterButton addButton;

    public OCEntry(Minecraft mc, int index, int maxIndex, EnumHand hand, ItemOCMessage message, AbstractEntry.ActionListener actionListener) {
        super(mc, index, maxIndex, hand, message.name, actionListener);
        this.message = message;
        int tId = 0;
        this.addressField = new BetterTextField(tId++, mc.field_71466_p, 0, 0, 222, 20, message.address).setMaxStringLengthBetter(36).setActionCallback(() -> this.ocAction(OCActionEnum.CHANGE_ADDRESS));
        this.portField = new BetterTextField(tId++, mc.field_71466_p, 0, 0, 38, 20, String.valueOf(message.port)).setNumbersOnly().setMaxStringLengthBetter(5).setActionCallback(() -> this.ocAction(OCActionEnum.CHANGE_PORT));
        this.paramField = new BetterTextField(tId++, mc.field_71466_p, 0, 0, 100, 20, message.dataStr).setActionCallback(() -> this.ocAction(OCActionEnum.CHANGE_PARAMS));
        this.textFields.add(this.addressField);
        this.textFields.add(this.portField);
        this.textFields.add(this.paramField);
    }

    private void ocAction(OCActionEnum action) {
        String string = "";
        switch (action) {
            case CHANGE_ADDRESS: {
                string = this.addressField.func_146179_b();
                break;
            }
            case CHANGE_PORT: {
                try {
                    int port = Integer.valueOf(this.portField.func_146179_b());
                    if (port < 0 || port > 65535) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("item.aunis.gui.oc_port_invalid", new Object[0]), true);
                    return;
                }
                string = this.portField.func_146179_b();
                break;
            }
            case CHANGE_PARAMS: {
                string = this.paramField.func_146179_b();
            }
        }
        AunisPacketHandler.INSTANCE.sendToServer((IMessage)new OCActionToServer(this.hand, action, this.index, string));
    }

    @Override
    protected int getHeight() {
        return 20;
    }

    @Override
    protected int getMaxNameLength() {
        return 16;
    }

    @Override
    protected EntryDataTypeEnum getEntryDataType() {
        return EntryDataTypeEnum.OC;
    }
}

