/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.entry;

import mrjake.aunis.gui.entry.AbstractAddressEntry;
import mrjake.aunis.gui.entry.AbstractEntry;
import mrjake.aunis.packet.gui.entry.EntryDataTypeEnum;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumHand;

public class NotebookEntry
extends AbstractAddressEntry {
    public static final int ADDRESS_WIDTH = 160;
    public static final int BUTTON_COUNT = 3;

    public NotebookEntry(Minecraft mc, int index, int maxIndex, EnumHand hand, String name, AbstractEntry.ActionListener reloadListener, SymbolTypeEnum type, StargateAddress addr, int maxSymbols) {
        super(mc, index, maxIndex, hand, name, reloadListener, type, addr, maxSymbols);
    }

    @Override
    public void renderAt(int dx, int dy, int mouseX, int mouseY, float partialTicks) {
        int size = 20;
        int x = dx + (160 - 20 * this.maxSymbols) / 2;
        for (int i = 0; i < this.maxSymbols; ++i) {
            SymbolInterface symbol = this.stargateAddress.get(i);
            NotebookEntry.renderSymbol(x, dy, 20, 20, symbol);
            x += 20;
        }
        super.renderAt(dx + 160 + 10, dy, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getHeight() {
        return 20;
    }

    @Override
    protected int getMaxNameLength() {
        return 11;
    }

    @Override
    protected EntryDataTypeEnum getEntryDataType() {
        return EntryDataTypeEnum.PAGE;
    }
}

