/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.element;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mrjake.aunis.Aunis;
import mrjake.aunis.beamer.BeamerModeEnum;
import mrjake.aunis.gui.element.GuiHelper;
import mrjake.aunis.gui.element.Tab;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.BeamerChangedInactivityToServer;
import mrjake.aunis.packet.BeamerChangedLevelsToServer;
import mrjake.aunis.packet.ChangeRedstoneModeToServer;
import mrjake.aunis.tileentity.util.RedstoneModeEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TabRedstone
extends Tab {
    private List<LabeledTextBox> textBoxes = new ArrayList<LabeledTextBox>();
    private RedstoneModeGetter modeGetter;
    private BeamerModeGetter beamerModeGetter;
    private BlockPos pos;
    private GuiButton saveButton;
    private boolean invalid;

    protected TabRedstone(TabRedstoneBuilder builder) {
        super(builder);
        this.modeGetter = builder.modeGetter;
        this.beamerModeGetter = builder.beamerModeGetter;
        this.pos = builder.pos;
        this.textBoxes.clear();
        this.textBoxes.add(new LabeledTextBox(0, this.defaultY + 52, builder.fontRenderer, "gui.beamer.activate_below"));
        this.textBoxes.add(new LabeledTextBox(0, this.defaultY + 52 + 33, builder.fontRenderer, "gui.beamer.deactivate_over"));
        this.textBoxes.add(new LabeledTextBox(0, this.defaultY + 52, builder.fontRenderer, "gui.beamer.deactivate", "gui.beamer.after_inactivity"));
        this.saveButton = new GuiButton(0, 0, this.guiTop + this.defaultY + 102, 35, 20, I18n.func_135052_a((String)"gui.beamer.save", (Object[])new Object[0]));
    }

    public void setText(int index, int number) {
        this.textBoxes.get(index).setText(number);
    }

    private List<LabeledTextBox> getTextBoxes(BeamerModeEnum beamerMode) {
        if (beamerMode == BeamerModeEnum.ITEMS) {
            return this.textBoxes.subList(2, 3);
        }
        if (beamerMode != BeamerModeEnum.NONE) {
            return this.textBoxes.subList(0, 2);
        }
        return new ArrayList<LabeledTextBox>();
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.render(fontRenderer, mouseX, mouseY);
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(this.bgTexLocation);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 21), (int)(this.guiTop + this.defaultY + 80), (float)149.0f, (float)207.0f, (int)107, (int)49, (float)this.textureSize, (float)this.textureSize);
        RedstoneModeEnum currentMode = this.modeGetter.get();
        for (int i = 0; i < RedstoneModeEnum.values().length; ++i) {
            RedstoneModeEnum redstoneMode = RedstoneModeEnum.values()[i];
            boolean active = false;
            ButtonXY b = this.getButtonXY(i);
            active |= redstoneMode == currentMode;
            int yTex = (active |= GuiHelper.isPointInRegion(b.x, b.y, 20, 20, mouseX, mouseY)) ? 214 : 194;
            GuiHelper.drawTexturedRect(b.x, b.y, 128, yTex, 20, 20);
            GuiHelper.drawTexturedRect(b.x + 2, b.y + 2, 148 + 16 * i, 176, 16, 15);
        }
        if (currentMode == RedstoneModeEnum.AUTO) {
            for (LabeledTextBox textBox : this.getTextBoxes(this.beamerModeGetter.get())) {
                textBox.draw();
            }
            this.saveButton.field_146128_h = this.guiLeft + this.currentOffsetX + 90;
            this.saveButton.func_191745_a(mc, mouseX, mouseY, 0.0f);
            int y = this.guiTop + this.defaultY + 68;
            if (this.beamerModeGetter.get() == BeamerModeEnum.ITEMS) {
                y += 10;
            }
            if (this.invalid) {
                fontRenderer.func_78276_b(TextFormatting.DARK_RED + I18n.func_135052_a((String)"gui.beamer.invalid", (Object[])new Object[0]), this.guiLeft + this.currentOffsetX + 90, y, 0xFFFFFF);
            }
        }
        GlStateManager.func_179084_k();
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        if (this.isOpen()) {
            for (int i = 0; i < RedstoneModeEnum.values().length; ++i) {
                ButtonXY b = this.getButtonXY(i);
                if (!GuiHelper.isPointInRegion(b.x, b.y, 20, 20, mouseX, mouseY)) continue;
                RedstoneModeEnum mode = RedstoneModeEnum.valueOf(i);
                String text = I18n.func_135052_a((String)mode.translationKey, (Object[])new Object[0]);
                if (mode == RedstoneModeEnum.IGNORED && Aunis.ocWrapper.isModLoaded()) {
                    text = text + " (OpenComputers)";
                }
                screen.func_146279_a(text, mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
    }

    private ButtonXY getButtonXY(int i) {
        int x = this.guiLeft + this.currentOffsetX + 33 + 23 * i;
        int y = this.guiTop + this.defaultY + 23;
        return new ButtonXY(x, y);
    }

    public void keyTyped(char typedChar, int keyCode) throws IOException {
        for (LabeledTextBox tf : this.getTextBoxes(this.beamerModeGetter.get())) {
            tf.textField.func_146201_a(typedChar, keyCode);
        }
    }

    public void updateScreen() {
        for (LabeledTextBox tf : this.getTextBoxes(this.beamerModeGetter.get())) {
            tf.textField.func_146178_a();
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isOpen()) {
            return;
        }
        RedstoneModeEnum currentMode = this.modeGetter.get();
        for (LabeledTextBox tf : this.getTextBoxes(this.beamerModeGetter.get())) {
            tf.textField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        for (int i = 0; i < RedstoneModeEnum.values().length; ++i) {
            ButtonXY b = this.getButtonXY(i);
            if (!GuiHelper.isPointInRegion(b.x, b.y, 20, 20, mouseX, mouseY)) continue;
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new ChangeRedstoneModeToServer(this.pos, RedstoneModeEnum.valueOf(i)));
            break;
        }
        if (currentMode == RedstoneModeEnum.AUTO && this.saveButton.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            switch (this.beamerModeGetter.get()) {
                case POWER: 
                case FLUID: {
                    int start = 0;
                    int stop = 0;
                    try {
                        start = Integer.valueOf(this.textBoxes.get(0).textField.func_146179_b());
                        stop = Integer.valueOf(this.textBoxes.get(1).textField.func_146179_b());
                        if (start < 0 || stop > 100 || start >= stop) {
                            throw new NumberFormatException();
                        }
                        AunisPacketHandler.INSTANCE.sendToServer((IMessage)new BeamerChangedLevelsToServer(this.pos, start, stop));
                        this.invalid = false;
                    }
                    catch (NumberFormatException e) {
                        this.invalid = true;
                    }
                    break;
                }
                case ITEMS: {
                    int inactivity = 0;
                    try {
                        inactivity = Integer.valueOf(this.textBoxes.get(2).textField.func_146179_b());
                        if (inactivity < 0) {
                            throw new NumberFormatException();
                        }
                        AunisPacketHandler.INSTANCE.sendToServer((IMessage)new BeamerChangedInactivityToServer(this.pos, inactivity));
                        this.invalid = false;
                    }
                    catch (NumberFormatException e) {
                        this.invalid = true;
                    }
                    break;
                }
            }
        }
    }

    public static TabRedstoneBuilder builder() {
        return new TabRedstoneBuilder();
    }

    public static interface BeamerModeGetter {
        public BeamerModeEnum get();
    }

    public static interface RedstoneModeGetter {
        public RedstoneModeEnum get();
    }

    public static class TabRedstoneBuilder
    extends Tab.TabBuilder {
        private FontRenderer fontRenderer;
        private RedstoneModeGetter modeGetter;
        private BeamerModeGetter beamerModeGetter;
        private BlockPos pos;

        public TabRedstoneBuilder setFontRenderer(FontRenderer fontRenderer) {
            this.fontRenderer = fontRenderer;
            return this;
        }

        public TabRedstoneBuilder setRedstoneModeGetter(RedstoneModeGetter modeGetter) {
            this.modeGetter = modeGetter;
            return this;
        }

        public TabRedstoneBuilder setBeamerModeGetter(BeamerModeGetter beamerModeGetter) {
            this.beamerModeGetter = beamerModeGetter;
            return this;
        }

        public TabRedstoneBuilder setBlockPos(BlockPos pos) {
            this.pos = pos;
            return this;
        }

        @Override
        public TabRedstone build() {
            return new TabRedstone(this);
        }
    }

    private class LabeledTextBox {
        private int y;
        private List<String> text;
        private GuiTextField textField;
        private FontRenderer fontRenderer;

        public LabeledTextBox(int id, int y, FontRenderer fontRenderer, String ... translationKey) {
            this.y = TabRedstone.this.guiTop + y;
            this.fontRenderer = fontRenderer;
            this.text = new ArrayList<String>();
            for (String tr : translationKey) {
                this.text.add(I18n.func_135052_a((String)tr, (Object[])new Object[0]));
            }
            this.textField = new GuiTextField(id, fontRenderer, 0, this.y + 11 * translationKey.length, 50, 16);
        }

        public LabeledTextBox setText(int number) {
            this.textField.func_146180_a("" + number);
            return this;
        }

        public void draw() {
            this.textField.field_146209_f = TabRedstone.this.guiLeft + TabRedstone.this.currentOffsetX + 31;
            int y = this.y;
            for (String text : this.text) {
                this.fontRenderer.func_78276_b(text, TabRedstone.this.guiLeft + TabRedstone.this.currentOffsetX + 29, y, 0x404040);
                y += 11;
            }
            this.textField.func_146194_f();
        }
    }

    private class ButtonXY {
        public final int x;
        public final int y;

        public ButtonXY(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

