/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.element;

import java.util.ArrayList;
import mrjake.aunis.Aunis;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.element.GuiHelper;
import mrjake.aunis.gui.element.ModeButton;
import mrjake.aunis.gui.element.NumberOnlyTextField;
import mrjake.aunis.gui.element.Tab;
import mrjake.aunis.stargate.EnumIrisMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class TabIris
extends Tab {
    protected static final ResourceLocation MODES_ICONS = new ResourceLocation("aunis", "textures/gui/iris_mode.png");
    protected NumberOnlyTextField inputField;
    public int code;
    public EnumIrisMode irisMode;
    protected ModeButton buttonChangeMode;
    private Runnable onTabClose;

    protected TabIris(TabIrisBuilder builder) {
        super(builder);
        this.inputField = new NumberOnlyTextField(1, Minecraft.func_71410_x().field_71466_p, this.guiLeft + 6, this.guiTop + this.defaultY + 25, 64, 16);
        this.buttonChangeMode = new ModeButton(1, this.inputField.field_146209_f + this.inputField.field_146218_h + 5, this.guiTop + this.defaultY + 25, 16, MODES_ICONS, 64, 32, 4);
        this.onTabClose = null;
        this.irisMode = builder.irisMode;
        this.code = builder.code;
        this.buttonChangeMode.setCurrentState(this.irisMode.id);
        this.inputField.func_146203_f(AunisConfig.irisConfig.irisCodeLength);
        this.inputField.func_146180_a(this.code > -1 ? Integer.toString(this.code) : "");
        this.inputField.func_146184_c(this.buttonChangeMode.getCurrentState() == EnumIrisMode.AUTO.id);
    }

    public void updateValue(EnumIrisMode irisMode) {
        this.buttonChangeMode.setCurrentState(irisMode.id);
        this.inputField.func_146184_c(this.buttonChangeMode.getCurrentState() == EnumIrisMode.AUTO.id);
    }

    public void updateValue(int irisCode) {
        this.inputField.func_146180_a(irisCode > 0 ? irisCode + "" : "");
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        super.render(fontRenderer, mouseX, mouseY);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttonChangeMode.field_146128_h = this.guiLeft + this.currentOffsetX + 64 + 11;
        this.buttonChangeMode.drawButton(mouseX, mouseY);
        GlStateManager.func_179084_k();
        this.inputField.field_146209_f = this.guiLeft + 6 + this.currentOffsetX;
        this.inputField.func_146194_f();
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && GuiHelper.isPointInRegion(this.buttonChangeMode.field_146128_h, this.buttonChangeMode.field_146129_i, this.buttonChangeMode.func_146117_b(), this.buttonChangeMode.func_146117_b(), mouseX, mouseY)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(I18n.func_135052_a((String)"gui.stargate.iris.help_title", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("gui.stargate.iris." + this.getIrisMode().name().toLowerCase()), (Object[])new Object[0]));
            text.add(TextFormatting.GRAY + I18n.func_135052_a((String)("gui.stargate.iris." + this.getIrisMode().name().toLowerCase() + "_help"), (Object[])new Object[0]));
            if (this.buttonChangeMode.getCurrentState() == 2) {
                text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.stargate.iris.auto1_help", (Object[])new Object[0]));
            }
            screen.func_146283_a(text, mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public static TabIrisBuilder builder() {
        return new TabIrisBuilder();
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.inputField.func_146192_a(mouseX, mouseY, mouseButton);
        if (GuiHelper.isPointInRegion(this.buttonChangeMode.field_146128_h, this.buttonChangeMode.field_146129_i, this.buttonChangeMode.field_146120_f, this.buttonChangeMode.field_146121_g, mouseX, mouseY)) {
            switch (mouseButton) {
                case 0: {
                    this.buttonChangeMode.nextState();
                    if (Aunis.ocWrapper.isModLoaded() || this.buttonChangeMode.getCurrentState() != 4) break;
                    this.buttonChangeMode.nextState();
                    break;
                }
                case 1: {
                    this.buttonChangeMode.previousState();
                    if (Aunis.ocWrapper.isModLoaded() || this.buttonChangeMode.getCurrentState() != 4) break;
                    this.buttonChangeMode.previousState();
                    break;
                }
                case 2: {
                    this.buttonChangeMode.setCurrentState(0);
                }
            }
            this.inputField.func_146184_c(this.buttonChangeMode.getCurrentState() == EnumIrisMode.AUTO.id);
            this.buttonChangeMode.func_146113_a(Minecraft.func_71410_x().func_147118_V());
        }
    }

    public EnumIrisMode getIrisMode() {
        return EnumIrisMode.getValue((byte)this.buttonChangeMode.getCurrentState());
    }

    public int getCode() {
        return this.inputField.func_146179_b().length() > 0 ? Integer.parseInt(this.inputField.func_146179_b()) : -1;
    }

    public void keyTyped(char typedChar, int keyCode) {
        this.inputField.func_146201_a(typedChar, keyCode);
    }

    public void setOnTabClose(Runnable onTabClose) {
        this.onTabClose = onTabClose;
    }

    @Override
    public void closeTab() {
        if (this.onTabClose != null) {
            this.onTabClose.run();
        }
        super.closeTab();
    }

    public static class TabIrisBuilder
    extends Tab.TabBuilder {
        private EnumIrisMode irisMode = EnumIrisMode.OPENED;
        private int code = -1;

        public TabIrisBuilder setCode(int code) {
            this.code = code;
            return this;
        }

        public TabIrisBuilder setIrisMode(EnumIrisMode irisMode) {
            this.irisMode = irisMode;
            return this;
        }

        @Override
        public TabIris build() {
            return new TabIris(this);
        }
    }
}

